/*
 * Decompiled with CFR 0.152.
 */
package de.renew.remote;

import de.renew.application.SimulationEnvironment;
import de.renew.engine.simulator.BindingList;
import de.renew.engine.simulator.SimulationThreadPool;
import de.renew.net.NetInstance;
import de.renew.net.NetInstanceList;
import de.renew.remote.NetInstanceAccessor;
import de.renew.remote.NetInstanceAccessorImpl;
import de.renew.remote.SimulatorAccessor;
import de.renew.remote.SocketFactoryDeterminer;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public class SimulatorAccessorImpl
extends UnicastRemoteObject
implements SimulatorAccessor {
    public static final Logger LOGGER = Logger.getLogger(SimulatorAccessorImpl.class);
    private final SimulationEnvironment _environment;

    public SimulatorAccessorImpl(SimulationEnvironment environment) throws RemoteException {
        super(0, SocketFactoryDeterminer.getInstance(), SocketFactoryDeterminer.getInstance());
        this._environment = environment;
    }

    @Override
    public NetInstanceAccessor[] getNetInstances() throws RemoteException {
        Future future = SimulationThreadPool.getCurrent().submitAndWait((Callable)new Callable<NetInstanceAccessor[]>(){

            @Override
            public NetInstanceAccessor[] call() throws Exception {
                NetInstance[] netInstances = NetInstanceList.getAll();
                NetInstanceAccessor[] result = new NetInstanceAccessor[netInstances.length];
                for (int i = 0; i < netInstances.length; ++i) {
                    result[i] = new NetInstanceAccessorImpl(netInstances[i], SimulatorAccessorImpl.this._environment);
                }
                return result;
            }
        });
        try {
            return (NetInstanceAccessor[])future.get();
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)e);
        }
        catch (ExecutionException e) {
            LOGGER.error((Object)"Simulation thread threw an exception", (Throwable)e);
        }
        return null;
    }

    @Override
    public boolean isActive() throws RemoteException {
        Future future = SimulationThreadPool.getCurrent().submitAndWait((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return SimulatorAccessorImpl.this._environment.getSimulator().isActive();
            }
        });
        try {
            return (Boolean)future.get();
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)e);
        }
        catch (ExecutionException e) {
            LOGGER.error((Object)"Simulation thread threw an exception", (Throwable)e);
        }
        return false;
    }

    @Override
    public void startRun() throws RemoteException {
        Future future = SimulationThreadPool.getCurrent().submitAndWait((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                SimulatorAccessorImpl.this._environment.getSimulator().startRun();
                return null;
            }
        });
        try {
            future.get();
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)e);
        }
        catch (ExecutionException e) {
            LOGGER.error((Object)"Simulation thread threw an exception", (Throwable)e);
        }
    }

    @Override
    public void stopRun() throws RemoteException {
        Future future = SimulationThreadPool.getCurrent().submitAndWait((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                SimulatorAccessorImpl.this._environment.getSimulator().stopRun();
                return null;
            }
        });
        try {
            future.get();
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)e);
        }
        catch (ExecutionException e) {
            LOGGER.error((Object)"Simulation thread threw an exception", (Throwable)e);
        }
    }

    @Override
    public void terminateRun() throws RemoteException {
        Future future = SimulationThreadPool.getCurrent().submitAndWait((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                SimulatorAccessorImpl.this._environment.getSimulator().terminateRun();
                return null;
            }
        });
        try {
            future.get();
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)e);
        }
        catch (ExecutionException e) {
            LOGGER.error((Object)"Simulation thread threw an exception", (Throwable)e);
        }
    }

    @Override
    public int step() throws RemoteException {
        Future future = SimulationThreadPool.getCurrent().submitAndWait((Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return SimulatorAccessorImpl.this._environment.getSimulator().step();
            }
        });
        try {
            return (Integer)future.get();
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)e);
        }
        catch (ExecutionException e) {
            LOGGER.error((Object)"Simulation thread threw an exception", (Throwable)e);
        }
        return -1;
    }

    @Override
    public void refresh() throws RemoteException {
        Future future = SimulationThreadPool.getCurrent().submitAndWait((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                SimulatorAccessorImpl.this._environment.getSimulator().refresh();
                return null;
            }
        });
        try {
            future.get();
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)e);
        }
        catch (ExecutionException e) {
            LOGGER.error((Object)"Simulation thread threw an exception", (Throwable)e);
        }
    }

    public void totallyStopSimulation() throws RemoteException {
        Future future = SimulationThreadPool.getCurrent().submitAndWait((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                SimulatorAccessorImpl.this._environment.getSimulator().stopRun();
                BindingList.waitUntilEmpty();
                return null;
            }
        });
        try {
            future.get();
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)e);
        }
        catch (ExecutionException e) {
            LOGGER.error((Object)"Simulation thread threw an exception", (Throwable)e);
        }
    }
}

