/*
 * Decompiled with CFR 0.152.
 */
package de.renew.remote;

import de.renew.application.SimulationEnvironment;
import de.renew.engine.simulator.SimulationThreadPool;
import de.renew.remote.Server;
import de.renew.remote.SimulatorAccessor;
import de.renew.remote.SimulatorAccessorImpl;
import de.renew.remote.SocketFactoryDeterminer;
import java.net.MalformedURLException;
import java.rmi.AlreadyBoundException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public class ServerImpl
extends UnicastRemoteObject
implements Server {
    public static final Logger LOGGER = Logger.getLogger(ServerImpl.class);
    private SimulationEnvironment _environment = null;

    public ServerImpl(SimulationEnvironment environment) throws RemoteException {
        super(0, SocketFactoryDeterminer.getInstance(), SocketFactoryDeterminer.getInstance());
        this._environment = environment;
    }

    @Override
    public SimulatorAccessor getSimulator() throws RemoteException {
        return new SimulatorAccessorImpl(this._environment);
    }

    public static String bindServer(final Server server, final String serverName, final boolean allowRebind) {
        Future future = SimulationThreadPool.getCurrent().submitAndWait((Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                String serverUrl;
                block6: {
                    serverUrl = ServerImpl.makeLocalServerUrl(serverName);
                    try {
                        try {
                            LOGGER.debug((Object)("ServerImpl: Binding server to URL " + serverUrl + "..."));
                            Naming.bind(serverUrl, server);
                            LOGGER.debug((Object)("ServerImpl: Bound to " + serverUrl + "."));
                        }
                        catch (AlreadyBoundException e) {
                            if (allowRebind) {
                                LOGGER.debug((Object)("ServerImpl: " + serverUrl + " already in use. Rebinding ..."));
                                Naming.rebind(serverUrl, server);
                                break block6;
                            }
                            LOGGER.error((Object)("ServerImpl: " + serverUrl + " already in use. Aborting."));
                            serverUrl = null;
                        }
                    }
                    catch (MalformedURLException e) {
                        LOGGER.error((Object)("ServerImpl: " + serverUrl + " is a malformed URL. Aborting."));
                        serverUrl = null;
                    }
                    catch (RemoteException e) {
                        LOGGER.warn((Object)("ServerImpl: Could not bind server to " + serverUrl + ": " + String.valueOf(e)));
                        serverUrl = null;
                    }
                }
                return serverUrl;
            }
        });
        try {
            return (String)future.get();
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)e);
        }
        catch (ExecutionException e) {
            LOGGER.error((Object)"Simulation thread threw an exception", (Throwable)e);
        }
        return null;
    }

    public static void unbindServer(String serverUrl) {
        try {
            LOGGER.debug((Object)("ServerImpl: Unbinding server from URL " + serverUrl + "..."));
            Naming.unbind(serverUrl);
            LOGGER.debug((Object)("ServerImpl: Unbound from " + serverUrl + "."));
        }
        catch (MalformedURLException e) {
            LOGGER.error((Object)("ServerImpl: " + serverUrl + " is a malformed URL. Unbinding failed."));
        }
        catch (NotBoundException e) {
            LOGGER.error((Object)("ServerImpl: " + serverUrl + " was not bound. Unbinding failed."));
        }
        catch (RemoteException e) {
            LOGGER.error((Object)("ServerImpl: Unbinding from " + serverUrl + " failed: " + String.valueOf(e)));
        }
    }

    public static synchronized Server getInstance(String hostName) throws RemoteException, NotBoundException {
        return ServerImpl.getInstance(hostName, "default");
    }

    public static synchronized Server getInstance(String hostName, String serverName) throws RemoteException, NotBoundException {
        try {
            return (Server)Naming.lookup(ServerImpl.makeServerUrl(hostName, serverName));
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("An internal error occurred: " + String.valueOf(e));
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(hostName + ":" + serverName + " is not a renew server");
        }
    }

    public static String makeLocalServerUrl(String servername) {
        return ServerImpl.makeServerUrl("localhost", servername);
    }

    public static String makeServerUrl(String hostName) {
        return ServerImpl.makeServerUrl(hostName, null);
    }

    public static String makeServerUrl(String hostName, String serverName) {
        return "//" + hostName + "/" + Server.class.getName() + "." + (serverName == null ? "default" : serverName);
    }
}

