/*
 * Decompiled with CFR 0.152.
 */
package de.renew.netcomponents;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.application.MenuManager;
import CH.ifa.draw.application.VersionInfoCommand;
import CH.ifa.draw.util.Command;
import CH.ifa.draw.util.CommandMenu;
import de.renew.gui.GuiPlugin;
import de.renew.netcomponents.ComponentsPluginExtender;
import de.renew.netcomponents.ComponentsTool;
import de.renew.netcomponents.GroupCommand;
import de.renew.netcomponents.RemoveLastNetComponentsToolCommand;
import de.renew.netcomponents.RemoveNetComponentsToolCommand;
import de.renew.netcomponents.RemoveToolsControl;
import de.renew.netcomponents.SelectNetComponentsToolCommand;
import de.renew.netcomponents.UngroupCommand;
import de.renew.plugin.IPlugin;
import de.renew.plugin.PluginManager;
import de.renew.plugin.PluginProperties;
import de.renew.plugin.PropertyHelper;
import de.renew.plugin.annotations.Inject;
import de.renew.plugin.di.DIPlugin;
import de.renew.windowmanagement.Workbench;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class ComponentsToolPlugin
extends DIPlugin {
    private static final Logger LOGGER = Logger.getLogger(ComponentsToolPlugin.class);
    private final Workbench _workbench;
    private CommandMenu _menu;
    private ComponentsTool _defCT;
    private Vector<ComponentsTool> _componentsToolList = new Vector();
    private static URL _location;
    private HashMap<String, ComponentsPluginExtender> _pluginList;
    private Hashtable<Command, ComponentsPluginExtender> _commandList;

    @Inject
    public ComponentsToolPlugin(Workbench workbench) {
        this.setDefaultCT(null);
        this._pluginList = new HashMap();
        this._commandList = new Hashtable();
        this._workbench = workbench;
    }

    public void init() {
        DrawPlugin dp = DrawPlugin.getCurrent();
        this._menu = this.createMenu();
        MenuManager mm = dp.getMenuManager();
        mm.registerMenu("Tools", (JMenuItem)this._menu);
        String toolDirProp = "user.toolsdir";
        String toolDir = this.getProperties().getProperty(toolDirProp);
        if (toolDir != null) {
            System.setProperty(toolDirProp, toolDir);
            LOGGER.debug((Object)("NetComponents: " + toolDirProp + " set to " + toolDir));
            try {
                boolean init;
                if (PropertyHelper.getBoolProperty((Properties)this.getProperties(), (String)"nc.init")) {
                    LOGGER.info((Object)"Your init option: de.renew.nc.init is set to true.");
                    LOGGER.info((Object)"This option is not supported anymore, whatsoever.");
                }
                if (init = PropertyHelper.getBoolProperty((Properties)this.getProperties(), (String)"de.renew.nc.init")) {
                    LOGGER.info((Object)"Your init option: de.renew.nc.init is set to true.");
                    LOGGER.info((Object)"However, this is not supported anymore.");
                    LOGGER.info((Object)"Please set the init option of the plugin providing your default palette.");
                }
            }
            catch (RuntimeException runtimeException) {}
        } else {
            LOGGER.error((Object)("NetComponents: " + toolDirProp + " not set in plugin.cfg."));
        }
    }

    public void registerPlugin(ComponentsPluginExtender plugin) {
        this._pluginList.put(plugin.getToolDirPath(), plugin);
        for (Command command : plugin.getMenuCommands()) {
            this._menu.add(command);
            this._commandList.put(command, plugin);
            LOGGER.debug((Object)("Added command " + command.toString() + " of Plugin " + String.valueOf(plugin)));
        }
    }

    public void deregisterPlugin(ComponentsPluginExtender plugin) {
        Enumeration<Command> it = this._commandList.keys();
        while (it.hasMoreElements()) {
            Command command = it.nextElement();
            if (this._commandList.get(command) != plugin) continue;
            this._menu.remove(command);
            this._commandList.remove(command);
        }
        this._pluginList.remove(plugin.getToolDirPath());
    }

    public boolean addEntryToMenu(Command command) {
        this._menu.add(command);
        return false;
    }

    public boolean removeEntryFromMenu(Command command) {
        this._menu.remove(command);
        return false;
    }

    public boolean cleanup() {
        this.unloadAllPalettes();
        DrawPlugin.getCurrent().getMenuManager().unregisterMenu((JMenuItem)this._menu);
        return true;
    }

    private void unloadAllPalettes() {
        for (ComponentsTool ct : this._componentsToolList) {
            ct.remove();
        }
        this._componentsToolList = new Vector();
    }

    public void createPalette(String name, String paletteName, ComponentsPluginExtender plugin) {
        File dir;
        block10: {
            dir = null;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)(ComponentsToolPlugin.class.getSimpleName() + ": " + name));
            }
            try {
                dir = new File(new URI("file://" + name));
            }
            catch (URISyntaxException e) {
                LOGGER.error((Object)(ComponentsToolPlugin.class.getSimpleName() + "Could not find dierectory: " + name + "/n" + e.getMessage()));
                if (!LOGGER.isDebugEnabled()) break block10;
                LOGGER.debug((Object)(ComponentsToolPlugin.class.getSimpleName() + ": Could not find dierectory: " + name + "/n" + String.valueOf(e)));
            }
        }
        String dirName = name;
        if (dir != null && dir.exists()) {
            ComponentsTool componentsTool;
            GuiPlugin starter = GuiPlugin.getCurrent();
            if (starter == null) {
                LOGGER.error((Object)"no gui starter object! cannot create palette.");
                return;
            }
            try {
                dirName = dir.getCanonicalPath();
            }
            catch (Exception se) {
                LOGGER.error((Object)("Security of FilePath violated. File: " + dir.getName() + "\n Exception: " + String.valueOf(se)));
            }
            if (this.componentsToolListcontains(dirName)) {
                this.removePalette(dirName);
            }
            if ((componentsTool = new ComponentsTool(dirName, paletteName, plugin, this._workbench)).toolsDirIsValid()) {
                this._componentsToolList.add(componentsTool);
            } else {
                JOptionPane.showMessageDialog(starter.getGuiFrame(), "No valid net component directory was selected.", "Abort", 2, new ImageIcon(starter.getClass().getResource("/de/renew/gui/images/RENEW.gif")));
            }
        }
    }

    public void createPalette() {
        block7: {
            try {
                GuiPlugin starter = GuiPlugin.getCurrent();
                if (starter == null) {
                    LOGGER.error((Object)"no gui starter object! cannot create palette.");
                    return;
                }
                if (this.getDefaultCT() == null) {
                    ComponentsTool ct = new ComponentsTool(this._workbench);
                    if (ct.toolsDirIsValid()) {
                        this._componentsToolList.add(ct);
                        this.setDefaultCT(ct);
                    } else {
                        JOptionPane.showMessageDialog(starter.getGuiFrame(), "The 'user.toolsdir' propery is not set to a valid net component directory.\n Set this property in \"renew.properties\" in the \"config\" directory of your renew installation and restart the program\nor use the menu entry \"Edit > Netcomponents > select from directory\"!", "Abort", 2, new ImageIcon(starter.getClass().getResource("/de/renew/gui/images/RENEW.gif")));
                    }
                } else {
                    this.getDefaultCT().remove();
                    this._componentsToolList.remove(this.getDefaultCT());
                    this.setDefaultCT(null);
                }
            }
            catch (Exception ee) {
                LOGGER.error((Object)("Something went wrong while toggling the default palette. Palette is: " + String.valueOf(this.getDefaultCT()) + " Message: " + String.valueOf(ee)));
                if (this.getDefaultCT() == null) break block7;
                LOGGER.error((Object)("Directory is: " + this.getDefaultCT().getLabel()));
            }
        }
    }

    public void selectDirAndCreatePalette() {
        File dir = this.getDirectory();
        String dirName = "";
        if (dir != null) {
            GuiPlugin starter = GuiPlugin.getCurrent();
            if (starter == null) {
                LOGGER.error((Object)"no gui starter object! cannot create palette.");
                return;
            }
            try {
                dirName = dir.getCanonicalPath();
            }
            catch (Exception se) {
                LOGGER.error((Object)("Security of FilePath violated. File: " + dir.getName() + "\n Exception: " + String.valueOf(se)));
            }
            String name = this.guessPalettenameFromDirName(dir);
            ComponentsTool componentsTool = new ComponentsTool(dirName, name, null, this._workbench);
            if (componentsTool.toolsDirIsValid()) {
                this._componentsToolList.add(componentsTool);
            } else {
                JOptionPane.showMessageDialog(starter.getGuiFrame(), "No valid net component directory was selected.", "Abort", 2, new ImageIcon(starter.getClass().getResource("/de/renew/gui/images/RENEW.gif")));
            }
        }
    }

    private String guessPalettenameFromDirName(File dir) {
        File currentDir = dir;
        int maxDepth = 3;
        block2: do {
            File[] files;
            if ((files = (currentDir = currentDir.getParentFile()).listFiles()) == null) continue;
            for (File file : files) {
                if (!file.isDirectory() || !file.getName().endsWith("etc")) continue;
                try {
                    Path path = Paths.get(file.getAbsolutePath(), "plugin.cfg");
                    File configFile = path.toFile();
                    URL url = configFile.toURI().toURL();
                    PluginProperties properties = new PluginProperties(url, url.openStream());
                    String result = properties.getName();
                    if (result != "unknown") {
                        return result;
                    }
                    return "Components";
                }
                catch (IOException e) {
                    e.printStackTrace();
                    continue block2;
                }
            }
        } while (currentDir.getParentFile() != null && --maxDepth > 0);
        return "Components";
    }

    private boolean componentsToolListcontains(String componentsToolDirName) {
        for (ComponentsTool ct : this._componentsToolList) {
            if (!ct.getLabel().equals(componentsToolDirName)) continue;
            return true;
        }
        return false;
    }

    public void removeLastPalette() {
        GuiPlugin starter = GuiPlugin.getCurrent();
        if (starter == null) {
            LOGGER.error((Object)"no gui starter object! cannot remove last palette.");
            return;
        }
        if (!this._componentsToolList.isEmpty()) {
            ComponentsTool componentsTool = this._componentsToolList.lastElement();
            if (componentsTool == this.getDefaultCT()) {
                this.setDefaultCT(null);
            }
            componentsTool.remove();
            this._componentsToolList.remove(componentsTool);
            Object var2_2 = null;
        } else {
            starter.showStatus("Nothing to do.");
        }
    }

    public void removePalette() {
        GuiPlugin starter = GuiPlugin.getCurrent();
        if (starter == null) {
            LOGGER.error((Object)"no gui starter object! cannot remove palette.");
            return;
        }
        if (!this._componentsToolList.isEmpty()) {
            new RemoveToolsControl(this);
        } else {
            starter.showStatus("Nothing to do.");
        }
    }

    public void removePalette(String toolDirPath) {
        Iterator<ComponentsTool> it = this._componentsToolList.iterator();
        ComponentsTool toRemove = null;
        while (it.hasNext()) {
            ComponentsTool ct = it.next();
            if (!toolDirPath.equals(ct.getLabel())) continue;
            toRemove = ct;
        }
        if (toRemove != null) {
            this._componentsToolList.remove(toRemove);
            toRemove.remove();
            toRemove = null;
        }
    }

    public File getDirectory() {
        GuiPlugin starter = GuiPlugin.getCurrent();
        if (starter == null) {
            LOGGER.error((Object)"no gui starter object! cannot create palette.");
            return null;
        }
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        int check = chooser.showOpenDialog(starter.getGuiFrame());
        if (check == 0) {
            return chooser.getSelectedFile();
        }
        return null;
    }

    public Vector<ComponentsTool> getCTList() {
        return this._componentsToolList;
    }

    public ComponentsTool getDefaultCT() {
        return this._defCT;
    }

    public void setDefaultCT(ComponentsTool ct) {
        this._defCT = ct;
    }

    public static URL getLocation() {
        return _location;
    }

    public static void setLocation(URL url) {
        _location = url;
    }

    private CommandMenu createMenu() {
        CommandMenu menu = new CommandMenu("Netcomponents");
        menu.add((Command)new SelectNetComponentsToolCommand((IPlugin)this));
        menu.add((Command)new RemoveNetComponentsToolCommand((IPlugin)this));
        menu.add((Command)new RemoveLastNetComponentsToolCommand((IPlugin)this));
        menu.add((Command)new GroupCommand(), 49);
        menu.add((Command)new UngroupCommand(), 51);
        menu.addSeparator();
        menu.add((Command)new VersionInfoCommand((IPlugin)this));
        menu.addSeparator();
        JMenuItem palettesHeading = menu.add("Available Palettes");
        palettesHeading.setEnabled(false);
        palettesHeading.setFont(palettesHeading.getFont().deriveFont(1));
        menu.putClientProperty((Object)"ch.ifa.draw.menu.id", (Object)"de.renew.gui.nc");
        return menu;
    }

    public static ComponentsToolPlugin getCurrent() {
        return (ComponentsToolPlugin)PluginManager.getInstance().getPluginByName("Renew NetComponents");
    }
}

