/*
 * Decompiled with CFR 0.152.
 */
package de.renew.logging.gui;

import CH.ifa.draw.util.AWTSynchronizedUpdate;
import de.renew.logging.gui.RepositoryChangeListener;
import de.renew.logging.gui.StepTrace;
import de.renew.logging.gui.StepTraceChangeListener;
import de.renew.logging.gui.StepTraceRemoveRequest;
import de.renew.logging.gui.StepTraceRepository;
import java.awt.EventQueue;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class RepositoryChangeBuffer
implements RepositoryChangeListener {
    private static final Logger LOGGER = Logger.getLogger(RepositoryChangeBuffer.class);
    private static final long MIN_DELAY = 15L;
    private Map<StepTrace, BufferedEvent> _buffer = new HashMap<StepTrace, BufferedEvent>();
    private AWTSynchronizedUpdate _updater;
    protected Set<StepTraceChangeListener> _listeners = new HashSet<StepTraceChangeListener>();

    public RepositoryChangeBuffer() {
        this._updater = new AWTSynchronizedUpdate(15L, new Runnable(){

            @Override
            public void run() {
                RepositoryChangeBuffer.this.fireBulkUpdate();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireBulkUpdate() {
        Map<StepTrace, BufferedEvent> bulkbuffer;
        assert (EventQueue.isDispatchThread()) : "RepositoryChangeBuffer.fireBulkUpdate must be executed in the event thread.";
        RepositoryChangeBuffer repositoryChangeBuffer = this;
        synchronized (repositoryChangeBuffer) {
            bulkbuffer = this._buffer;
            this._buffer = new HashMap<StepTrace, BufferedEvent>();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)(String.valueOf(this) + ": preparing bulk update with " + bulkbuffer.size() + " events."));
        }
        TreeMap<StepTrace, BufferedEvent> sortedBuffer = new TreeMap<StepTrace, BufferedEvent>(new StepTraceComparator());
        sortedBuffer.putAll(bulkbuffer);
        for (BufferedEvent bev : sortedBuffer.values()) {
            switch (bev._kind) {
                case ADD: {
                    this.fireStepTraceAdded(bev._repository, bev._step);
                    break;
                }
                case CHANGE: {
                    this.fireStepTraceChanged(bev._step);
                    break;
                }
                case REMOVE: {
                    this.fireStepTraceRemoved(bev._repository, bev._step);
                }
            }
        }
    }

    public void addStepTraceChangeListener(StepTraceChangeListener listener) {
        this._listeners.add(listener);
    }

    public void removeStepTraceChangeListener(StepTraceChangeListener listener) {
        this._listeners.remove(listener);
    }

    protected void fireStepTraceChanged(StepTrace stepTrace) {
        StepTraceChangeListener[] l = this._listeners.toArray(new StepTraceChangeListener[0]);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)(String.valueOf(this) + ": Sending change for step " + String.valueOf(stepTrace) + " to " + l.length + " listeners."));
        }
        for (int x = 0; x < l.length; ++x) {
            l[x].stepTraceChanged(stepTrace);
        }
    }

    protected void fireStepTraceAdded(StepTraceRepository repository, StepTrace stepTrace) {
        StepTraceChangeListener[] l = this._listeners.toArray(new StepTraceChangeListener[0]);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)(String.valueOf(this) + ": Sending add for step " + String.valueOf(stepTrace) + " to " + l.length + " listeners."));
        }
        for (int x = 0; x < l.length; ++x) {
            if (!(l[x] instanceof RepositoryChangeListener)) continue;
            ((RepositoryChangeListener)l[x]).stepTraceAdded(repository, stepTrace);
        }
    }

    protected void fireStepTraceRemoved(StepTraceRepository repository, StepTrace stepTrace) {
        StepTraceChangeListener[] l = this._listeners.toArray(new StepTraceChangeListener[0]);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)(String.valueOf(this) + ": Sending remove for step " + String.valueOf(stepTrace) + " to " + l.length + " listeners."));
        }
        for (int x = 0; x < l.length; ++x) {
            if (!(l[x] instanceof RepositoryChangeListener)) continue;
            ((RepositoryChangeListener)l[x]).stepTraceRemoved(repository, stepTrace);
        }
    }

    @Override
    public synchronized void stepTraceChanged(StepTrace stepTrace) {
        if (this._buffer.containsKey(stepTrace)) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace((Object)(String.valueOf(this) + ": Discarding change " + String.valueOf(stepTrace)));
            }
        } else {
            this._buffer.put(stepTrace, new BufferedEvent(BufferedEvent.Kind.CHANGE, stepTrace, null));
            if (this._updater != null) {
                this._updater.scheduleUpdate();
            }
        }
    }

    @Override
    public synchronized void stepTraceAdded(StepTraceRepository repository, StepTrace stepTrace) {
        if (this._buffer.containsKey(stepTrace)) {
            LOGGER.warn((Object)(String.valueOf(this) + ": Add event is not the first event for step " + String.valueOf(stepTrace)));
        }
        this._buffer.put(stepTrace, new BufferedEvent(BufferedEvent.Kind.ADD, stepTrace, repository));
        if (this._updater != null) {
            this._updater.scheduleUpdate();
        }
    }

    @Override
    public synchronized void stepTraceRemoved(StepTraceRepository repository, StepTrace stepTrace) {
        if (this._buffer.containsKey(stepTrace) && this._buffer.get((Object)stepTrace)._kind == BufferedEvent.Kind.ADD) {
            this._buffer.remove(stepTrace);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace((Object)(String.valueOf(this) + ": Discarding add/remove pair for step " + String.valueOf(stepTrace)));
            }
        } else {
            this._buffer.put(stepTrace, new BufferedEvent(BufferedEvent.Kind.REMOVE, stepTrace, repository));
            if (this._updater != null) {
                this._updater.scheduleUpdate();
            }
        }
    }

    @Override
    public void stepTraceRemoveRequest(StepTraceRemoveRequest request) {
    }

    protected void stopBuffer() {
        this._updater = null;
    }

    private static class StepTraceComparator
    implements Comparator<StepTrace> {
        private StepTraceComparator() {
        }

        @Override
        public int compare(StepTrace o1, StepTrace o2) {
            long stepCount1 = o1.getStepIdentifier() != null && o1.getStepIdentifier().getComponents() != null && o1.getStepIdentifier().getComponents().length > 0 ? o1.getStepIdentifier().getComponents()[0] : 0L;
            long stepCount2 = o2.getStepIdentifier() != null && o2.getStepIdentifier().getComponents() != null && o2.getStepIdentifier().getComponents().length > 0 ? o2.getStepIdentifier().getComponents()[0] : 0L;
            return (int)Math.signum(stepCount1 - stepCount2);
        }
    }

    private static class BufferedEvent {
        public final Kind _kind;
        public final StepTrace _step;
        public final StepTraceRepository _repository;

        public BufferedEvent(Kind kind, StepTrace step, StepTraceRepository repository) {
            this._kind = kind;
            this._step = step;
            this._repository = repository;
        }

        public static enum Kind {
            ADD,
            CHANGE,
            REMOVE;

        }
    }
}

