/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hamburg.fs;

import de.renew.util.Types;
import de.renew.util.Value;
import de.uni_hamburg.fs.JavaClassType;
import de.uni_hamburg.fs.Name;
import de.uni_hamburg.fs.NullObject;
import de.uni_hamburg.fs.Type;
import de.uni_hamburg.fs.TypeException;
import de.uni_hamburg.fs.UnificationFailure;

public class BasicType
extends JavaClassType {
    public static final Object POSINF = new Name("POSINF");
    public static final Object NEGINF = new Name("NEGINF");
    private Object _lower;
    private Object _upper;
    private boolean _toBeInstantiated = false;

    public BasicType(Class<?> type) {
        if (type != String.class && !type.isPrimitive()) {
            throw new RuntimeException("Class " + String.valueOf(type) + " cannot be used as a BasicType.");
        }
        this.setJavaClass(type);
        this._lower = NEGINF;
        this._upper = POSINF;
    }

    public BasicType(Object single) {
        this(BasicType.getValueClass(single));
        this._lower = single;
        this._upper = single;
    }

    public BasicType(Object lower, Object upper) throws TypeException {
        this(BasicType.getValueClass(lower, upper), lower, upper);
    }

    public BasicType(Class<?> type, Object lower, Object upper) throws TypeException {
        BasicType.checkClass(type, lower);
        BasicType.checkClass(type, upper);
        if (this.compare(lower, upper) > 0) {
            throw new TypeException();
        }
        this.setJavaClass(type);
        this._lower = lower;
        this._upper = upper;
    }

    private BasicType(Class<?> type, Object lower, Object upper, boolean toBeInstantiated) {
        super(type);
        this._lower = lower;
        this._upper = upper;
        this._toBeInstantiated = toBeInstantiated;
    }

    private static Class<?> getValueClass(Object a) {
        if (a instanceof String) {
            return String.class;
        }
        try {
            return Types.typify(((Value)a).value.getClass());
        }
        catch (ClassCastException cce) {
            throw new RuntimeException("Class " + String.valueOf(a.getClass()) + " cannot be used as a BasicType.");
        }
    }

    private static Class<?> getValueClass(Object lower, Object upper) throws TypeException {
        if (!NEGINF.equals(lower)) {
            return BasicType.getValueClass(lower);
        }
        if (!POSINF.equals(upper)) {
            return BasicType.getValueClass(upper);
        }
        throw new TypeException();
    }

    private static void checkClass(Class<?> type, Object a) throws TypeException {
        Class<?> aclass;
        if (!POSINF.equals(a) && !NEGINF.equals(a) && (aclass = BasicType.getValueClass(a)) != type) {
            throw new TypeException();
        }
    }

    public boolean isObject() {
        return this._lower.equals(this._upper);
    }

    @Override
    public boolean isInstanceType() {
        return this._toBeInstantiated;
    }

    @Override
    public Type getInstanceType() {
        if (this.isInstanceType()) {
            return this;
        }
        return new BasicType(this.getJavaClass(), this._lower, this._upper, true);
    }

    @Override
    public Object getJavaObject() {
        if (!this.isObject()) {
            throw new RuntimeException("getJavaObject() called in BasicType although lower and upper did not meet!");
        }
        return this._lower;
    }

    public static String objToString(Object obj) {
        if (NEGINF.equals(obj) || POSINF.equals(obj)) {
            return "*";
        }
        if (obj instanceof String) {
            return "\"" + String.valueOf(obj) + "\"";
        }
        if (obj instanceof Value) {
            return ((Value)obj).value.toString();
        }
        if (obj == null) {
            return "null";
        }
        return obj.toString();
    }

    @Override
    public String getName() {
        StringBuffer output = new StringBuffer();
        if (NEGINF.equals(this._lower) && POSINF.equals(this._upper)) {
            if (this.getJavaClass() == String.class) {
                output.append("String");
            } else {
                output.append(this.getJavaClass().getName());
            }
        } else if (this._upper.equals(this._lower)) {
            output.append(BasicType.objToString(this._lower));
        } else {
            output.append("{").append(BasicType.objToString(this._lower)).append("..").append(BasicType.objToString(this._upper)).append("}");
        }
        return output.toString();
    }

    @Override
    public String getFullName() {
        return this.getName();
    }

    @Override
    public boolean isExtensional() {
        return this.isObject();
    }

    @Override
    public boolean subsumes(Type that) {
        if (that instanceof BasicType) {
            BasicType thatBasic = (BasicType)that;
            if (this._toBeInstantiated && !thatBasic._toBeInstantiated || thatBasic.getJavaClass() != this.getJavaClass()) {
                return false;
            }
            return this.compare(this._lower, thatBasic._lower) <= 0 && this.compare(this._upper, thatBasic._upper) >= 0;
        }
        if (that instanceof NullObject) {
            return this.getJavaClass() == String.class && this._lower.equals(NEGINF) && this._upper.equals(POSINF);
        }
        return false;
    }

    @Override
    public Type unify(Type that) throws UnificationFailure {
        if (that.equals(Type.TOP)) {
            return this;
        }
        if (this.subsumes(that)) {
            return that;
        }
        if (that instanceof BasicType) {
            BasicType thatBasic = (BasicType)that;
            if (thatBasic.getJavaClass() == this.getJavaClass()) {
                Object newUpper;
                Object newLower = this.max(this._lower, thatBasic._lower);
                if (this.compare(newLower, newUpper = this.min(this._upper, thatBasic._upper)) > 0) {
                    throw new TypeException();
                }
                return new BasicType(this.getJavaClass(), newLower, newUpper, this._toBeInstantiated || thatBasic._toBeInstantiated);
            }
        } else if (that.subsumes(this)) {
            return this;
        }
        throw new UnificationFailure();
    }

    @Override
    public boolean canUnify(Type that) {
        if (that.equals(Type.TOP)) {
            return true;
        }
        if (that instanceof BasicType) {
            BasicType thatBasic = (BasicType)that;
            if (thatBasic.getJavaClass() == this.getJavaClass()) {
                return this.compare(this._lower, thatBasic._upper) <= 0 && this.compare(thatBasic._lower, this._upper) <= 0;
            }
            return false;
        }
        return this.subsumes(that);
    }

    @Override
    public Type mostGeneralExtensionalSupertype(Type that) {
        return null;
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof BasicType) {
            BasicType thatBasic = (BasicType)that;
            return this._toBeInstantiated == thatBasic._toBeInstantiated && super.equals(that) && thatBasic._lower.equals(this._lower) && thatBasic._upper.equals(this._upper);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.getJavaClass().hashCode() + this._lower.hashCode() + this._upper.hashCode();
    }

    int compare(Object a, Object b) {
        if (a.equals(b)) {
            return 0;
        }
        if (NEGINF.equals(a) || POSINF.equals(b)) {
            return -1;
        }
        if (POSINF.equals(a) || NEGINF.equals(b)) {
            return 1;
        }
        if (a instanceof String && b instanceof String) {
            return ((String)a).compareTo((String)b);
        }
        if (a instanceof Value && b instanceof Value) {
            Value av = (Value)a;
            Value bv = (Value)b;
            Object ao = av.value;
            Object bo = bv.value;
            if (!ao.getClass().equals(bo.getClass())) {
                throw new RuntimeException("Different BasicType Classes: " + String.valueOf(ao.getClass()) + " and " + String.valueOf(bo.getClass()));
            }
            if (ao instanceof Boolean) {
                return bv.booleanValue() ? -1 : 1;
            }
            if (ao instanceof Character) {
                return av.charValue() < bv.charValue() ? -1 : 1;
            }
            if (ao instanceof Byte) {
                return av.byteValue() < bv.byteValue() ? -1 : 1;
            }
            if (ao instanceof Short) {
                return av.shortValue() < bv.shortValue() ? -1 : 1;
            }
            if (ao instanceof Integer) {
                return av.intValue() < bv.intValue() ? -1 : 1;
            }
            if (ao instanceof Long) {
                return av.longValue() < bv.longValue() ? -1 : 1;
            }
            if (ao instanceof Float) {
                return av.floatValue() < bv.floatValue() ? -1 : 1;
            }
            if (ao instanceof Double) {
                return av.doubleValue() < bv.doubleValue() ? -1 : 1;
            }
            a = ao;
            b = bo;
        }
        throw new RuntimeException("Wrong BasicType classes: " + String.valueOf(a.getClass()) + " and/or " + String.valueOf(b.getClass()));
    }

    Object max(Object a, Object b) {
        return this.compare(a, b) >= 0 ? a : b;
    }

    Object min(Object a, Object b) {
        return this.compare(a, b) <= 0 ? a : b;
    }
}

