/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.fs;

import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.ConnectionFigure;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.Handle;
import CH.ifa.draw.framework.Locator;
import CH.ifa.draw.framework.ParentFigure;
import CH.ifa.draw.standard.ConnectionHandle;
import CH.ifa.draw.standard.RelativeLocator;
import CH.ifa.draw.util.ColorMap;
import CH.ifa.draw.util.ExtendedFont;
import CH.ifa.draw.util.Fontkit;
import CH.ifa.draw.util.StorableInput;
import de.renew.formalism.fs.ShadowConcept;
import de.renew.gui.NodeFigure;
import de.renew.gui.fs.AssocConnection;
import de.renew.gui.fs.AssociationHandle;
import de.renew.gui.fs.IsaConnection;
import de.renew.shadow.ShadowNet;
import de.renew.shadow.ShadowNetElement;
import de.renew.util.StringUtil;
import de.uni_hamburg.fs.JavaConcept;
import de.uni_hamburg.fs.TypeSystem;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class ConceptFigure
extends TextFigure
implements NodeFigure {
    private static final String STEREOTYPE_REGEXP = "^((?:<<|\u00ab)([a-zA-Z]*)(?:>>|\u00bb))\\n*";
    private static final String CONCEPT_REGEXP = "(/\\*(?:[^*]|\\*[^/])*\\*/)?\n*((?:@[^\\n]*\n)*)\\n*([\\.\\:\\_a-zA-Z0-9-]*)";
    private static final String SLOT_REGEXP = "\n*(/\\*(?:[^*]|\\*[^/])*\\*/)?\n*((?:@[^\\n]*\n)*)\\n*([^\n]+\n*)";
    public static final Logger LOGGER = Logger.getLogger(ConceptFigure.class);
    private static IsaConnection _fgIsaPrototype = new IsaConnection();
    private static IsaConnection _fgDisIsaPrototype = new IsaConnection(false);
    private static AssocConnection _fgAssocPrototype = new AssocConnection();
    private String _conceptStr = "";
    private String _appropStr = "";
    private int _typeIndex = 0;
    private transient ShadowConcept _shadow = null;
    private String _textWithDoc;
    private String _stereotype;
    private List<String> _slotDocumentation = new ArrayList<String>();
    private String _conceptDocumentation;
    private List<String> _slotAnnotation = new ArrayList<String>();
    private String _conceptAnnotation;

    public ConceptFigure() {
        this.setFrameColor(ColorMap.color((String)"Black"));
        this.setFillColor(ColorMap.color((String)"White"));
    }

    public Vector<Handle> handles() {
        Vector handles = super.handles();
        handles.addElement(new ConnectionHandle((Figure)this, RelativeLocator.north(), (ConnectionFigure)_fgDisIsaPrototype));
        handles.addElement(new ConnectionHandle((Figure)this, RelativeLocator.south(), (ConnectionFigure)_fgIsaPrototype));
        handles.addElement(new ConnectionHandle((Figure)this, RelativeLocator.east(), (ConnectionFigure)_fgAssocPrototype));
        String[] lines = this.getLines();
        Rectangle size = this.displayBox();
        Rectangle[] boxes = this.getLineBoxes(null);
        int yOffset = 0;
        boolean skippedClassName = false;
        if (boxes != null) {
            for (int i = 0; i < lines.length; ++i) {
                RelativeLocator locator = new RelativeLocator(0.0, (double)(2 * yOffset + boxes[i].height) / 2.0 / (double)size.height);
                yOffset += boxes[i].height;
                if ("".equals(lines[i]) || ConceptFigure.isStereotype(lines[i]) || ConceptFigure.isAnnotation(lines[i])) continue;
                if (skippedClassName) {
                    String name = null;
                    Object type = null;
                    StringTokenizer tokenizer = new StringTokenizer(lines[i], ":");
                    while (type == null && tokenizer.hasMoreTokens()) {
                        if (name == null) {
                            name = tokenizer.nextToken();
                            continue;
                        }
                        type = tokenizer.nextToken();
                    }
                    if (name == null || tokenizer.hasMoreTokens()) continue;
                    name = StringUtil.unspace(name);
                    if (type != null) {
                        type = StringUtil.unspace((String)type);
                    }
                    if (name == null) continue;
                    if (type == null) {
                        type = "UNKNOWN";
                    }
                    String frontModifier = "";
                    if (name.startsWith("#") || name.startsWith("+") || name.startsWith("-")) {
                        frontModifier = name.substring(0, 1);
                        name = StringUtil.unspace((String)name.substring(1));
                    }
                    Object backModifiers = "";
                    int bracePos = ((String)type).indexOf("{");
                    if (bracePos >= 0) {
                        backModifiers = " " + ((String)type).substring(bracePos);
                        type = StringUtil.unspace((String)((String)type).substring(0, bracePos));
                    }
                    boolean isCollection = false;
                    while (type != null && ((String)type).endsWith("[]")) {
                        isCollection = true;
                        type = ((String)type).substring(0, ((String)type).length() - 2);
                    }
                    if (!StringUtil.isNameOrEmpty((String)name, (boolean)false) || !StringUtil.isNameOrEmpty((String)type, (boolean)true)) continue;
                    type = "." + (String)type;
                    if (!"".equals(frontModifier)) {
                        type = frontModifier + (String)type;
                    }
                    name = StringUtil.unspace((String)(name + (String)backModifiers));
                    handles.addElement(new AssociationHandle(this, i, name, (String)type, isCollection, (Locator)locator, _fgAssocPrototype));
                    continue;
                }
                skippedClassName = true;
            }
        }
        return handles;
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.setReadOnly(false);
        this.setParent(null);
    }

    private static boolean isStereotype(String str) {
        return str.startsWith("<<") || str.startsWith("\u00ab");
    }

    private static boolean isAnnotation(String str) {
        return str.startsWith("@");
    }

    public String getStereotype() {
        Pattern pattern = Pattern.compile(STEREOTYPE_REGEXP);
        Matcher stereotypeMatcher = pattern.matcher(this._stereotype);
        if (this._stereotype.length() > 0) {
            if (stereotypeMatcher.find()) {
                return stereotypeMatcher.group(2);
            }
            LOGGER.error((Object)("The concept figure " + this._conceptStr + " does not follow the syntax rules in its stereotype specification: " + this._stereotype + "."));
            return null;
        }
        return this._stereotype;
    }

    protected void drawLine(Graphics g, int i) {
        if (!"".equals(this.getLine(i))) {
            super.drawLine(g, i);
        } else {
            int y = this.getLineBox((Graphics)g, (int)i).y;
            int width = this.displayBox().width;
            g.drawLine(-5, y + 1, width - 6, y + 1);
        }
    }

    protected String getLine(int i) {
        String line = super.getLine(i);
        if (line.startsWith("\\") || line.startsWith("_")) {
            return line.substring(1);
        }
        return line;
    }

    protected Font getLineFont(int i) {
        String line = super.getLine(i);
        Font font = super.getLineFont(i);
        int fontStyle = font.getStyle();
        if (i == this._typeIndex) {
            fontStyle |= 1;
        }
        if (line.length() > 0) {
            char styleChar = line.charAt(0);
            switch (styleChar) {
                case '\\': {
                    fontStyle |= 2;
                    break;
                }
                case '_': {
                    fontStyle |= ExtendedFont.UNDERLINED;
                }
            }
        }
        return Fontkit.getFont((String)font.getName(), (int)fontStyle, (int)font.getSize());
    }

    protected int getLineAlignment(int i) {
        if (i <= this._typeIndex) {
            return 1;
        }
        return super.getLineAlignment(i);
    }

    protected Dimension getLineDimension(int i, Graphics g) {
        if ("".equals(this.getLine(i))) {
            return new Dimension(0, 3);
        }
        return super.getLineDimension(i, g);
    }

    public void setText(String text) {
        if (text.equals(this._textWithDoc)) {
            return;
        }
        this._typeIndex = 0;
        this._appropStr = "";
        this._textWithDoc = text;
        this._conceptStr = text.trim();
        this._stereotype = "";
        this._conceptDocumentation = "";
        this._slotDocumentation = new ArrayList<String>();
        this._conceptAnnotation = "";
        this._slotAnnotation = new ArrayList<String>();
        String textWithDocumentation = this._textWithDoc;
        String implementationDescription = this.generateImplementationDescription();
        if (implementationDescription != null) {
            textWithDocumentation = implementationDescription;
        }
        textWithDocumentation = this.matchStereotype(textWithDocumentation);
        textWithDocumentation = this.matchConceptDeclaration(textWithDocumentation);
        if (implementationDescription != null) {
            this._appropStr = textWithDocumentation;
            this._textWithDoc = text = implementationDescription;
        } else {
            this.matchSlots(textWithDocumentation);
        }
        this.willChange();
        this.basicSetText((String)(this._appropStr.length() > 0 ? this._conceptStr + "\n\n" + this._appropStr : this._conceptStr));
        this.changed();
        LOGGER.debug((Object)("Concept name: \"" + this._conceptStr + "\", approp: \"" + this._appropStr + "\""));
    }

    private String generateImplementationDescription() {
        if (this._conceptStr.trim().length() > 0) {
            boolean wantPackages;
            int level = JavaConcept.getVisibilityLevel(this._conceptStr.charAt(0));
            if (level >= 0) {
                this._conceptStr = this._conceptStr.substring(1);
            }
            if (wantPackages = this._conceptStr.startsWith(".")) {
                this._conceptStr = this._conceptStr.substring(1);
            }
            TypeSystem ts = TypeSystem.instance();
            try {
                Class<?> clazz = ts.getJavaClass(this._conceptStr);
                String[] wellKnown = wantPackages ? new String[]{} : JavaConcept.getWellKnownPackages(clazz);
                String expandedText = level >= 0 ? JavaConcept.getImplementationDescription(clazz, level, wellKnown) : ts.getJavaConcept(clazz).getClassDescription(wellKnown);
                return expandedText;
            }
            catch (Throwable t) {
                return null;
            }
        }
        return null;
    }

    private void matchSlots(String textWithDocumentation) {
        Pattern slotPattern = Pattern.compile(SLOT_REGEXP);
        Matcher slotMatcher = slotPattern.matcher(textWithDocumentation);
        ArrayList<String> slots = new ArrayList<String>();
        while (slotMatcher.find()) {
            String comment = slotMatcher.group(1);
            String strippedComment = "";
            if (comment != null) {
                strippedComment = comment.substring("/**".length(), comment.length() - "*/\n".length()).trim();
            }
            this._slotDocumentation.add(strippedComment);
            String annotations = slotMatcher.group(2);
            this._slotAnnotation.add(annotations != null ? annotations : "");
            String slot = slotMatcher.group(3);
            slots.add(slot);
        }
        this._appropStr = String.join((CharSequence)"", slots);
    }

    private String matchConceptDeclaration(String textWithDocumentation) {
        Pattern conceptPattern = Pattern.compile(CONCEPT_REGEXP);
        Matcher conceptMatcher = conceptPattern.matcher(textWithDocumentation);
        if (conceptMatcher.find()) {
            String comment = conceptMatcher.group(1);
            String strippedComment = "";
            if (comment != null) {
                strippedComment = comment.substring("/**".length(), comment.length() - "*/\n".length()).trim();
            }
            this._conceptDocumentation = strippedComment;
            String annotations = conceptMatcher.group(2);
            this._conceptAnnotation = annotations != null ? annotations : "";
            this._conceptStr = this._stereotype.length() > 0 ? this._stereotype + "\n" + conceptMatcher.group(3) : conceptMatcher.group(3);
            textWithDocumentation = textWithDocumentation.substring(conceptMatcher.end());
        }
        return textWithDocumentation;
    }

    private String matchStereotype(String textWithDocumentation) {
        Pattern stereotypePattern = Pattern.compile(STEREOTYPE_REGEXP);
        Matcher stereotypeMatcher = stereotypePattern.matcher(textWithDocumentation);
        if (stereotypeMatcher.find()) {
            this._stereotype = stereotypeMatcher.group(1);
            if (this._stereotype.length() > 0) {
                this._typeIndex = 1;
            }
            textWithDocumentation = textWithDocumentation.substring(stereotypeMatcher.end());
        }
        return textWithDocumentation;
    }

    protected void internalSetText(String newText) {
        if (this._textWithDoc == null) {
            this._textWithDoc = newText;
        }
        super.internalSetTextHiddenParts(this._textWithDoc, newText);
    }

    public Rectangle displayBox() {
        Rectangle box = super.displayBox();
        return new Rectangle(box.x - 5, box.y, box.width + 10, box.height + 1);
    }

    public ShadowNetElement buildShadow(ShadowNet net) {
        this._shadow = new ShadowConcept(net, this._conceptStr, this._appropStr, this._conceptDocumentation, this._slotDocumentation, this._conceptAnnotation, this._slotAnnotation, this._stereotype);
        this._shadow.context = this;
        LOGGER.debug((Object)("shadow for concept " + this._conceptStr + " created!"));
        return this._shadow;
    }

    public ShadowNetElement getShadow() {
        return this._shadow;
    }

    public String getName() {
        return this._conceptStr;
    }

    public void release() {
        super.release();
        if (this._shadow != null) {
            this._shadow.discard();
        }
    }

    public boolean canBeParent(ParentFigure figure) {
        return figure == null;
    }
}

