/*
 * Decompiled with CFR 0.152.
 */
package de.renew.formalism.fs;

import de.renew.formalism.fs.ShadowConcept;
import de.renew.shadow.ShadowLookup;
import de.renew.shadow.ShadowLookupExtension;
import de.renew.shadow.ShadowLookupExtensionFactory;
import de.renew.shadow.ShadowNetElement;
import de.uni_hamburg.fs.ConceptImpl;
import de.uni_hamburg.fs.Name;
import de.uni_hamburg.fs.Partition;
import de.uni_hamburg.fs.TypeException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.log4j.Logger;

public class FSShadowLookupExtension
implements ShadowLookupExtension {
    public static final Logger LOGGER = Logger.getLogger(FSShadowLookupExtension.class);
    private static final Factory FACTORY = new Factory();
    private Hashtable<String, ConceptImpl> _conceptMap = new Hashtable();
    private Hashtable<String, ShadowNetElement> _appropMap = new Hashtable();
    private Hashtable<ConceptImpl, Partition> _partitionMap = new Hashtable();

    public static FSShadowLookupExtension lookup(ShadowLookup lookup) {
        return (FSShadowLookupExtension)lookup.getShadowLookupExtension((ShadowLookupExtensionFactory)FACTORY);
    }

    public void setConcept(ShadowConcept shadowConcept, ConceptImpl concept) {
        this._conceptMap.put(shadowConcept.getName(), concept);
    }

    public ConceptImpl getConcept(ShadowConcept shadowConcept) {
        return this._conceptMap.get(shadowConcept.getName());
    }

    public Enumeration<String> allConcepts() {
        return this._conceptMap.keys();
    }

    public void setApprop(ConceptImpl concept, Name feature, ShadowNetElement elem) {
        this._appropMap.put(concept.getName() + "." + String.valueOf(feature), elem);
    }

    public ShadowNetElement getApprop(ConceptImpl concept, Name feature) {
        return this._appropMap.get(concept.getName() + "." + String.valueOf(feature));
    }

    public void addToSubPartition(ConceptImpl supi, ConceptImpl sub) throws TypeException {
        Partition suppart = this._partitionMap.get(supi);
        if (suppart == null) {
            LOGGER.debug((Object)("Creating new sub-partition for " + supi.getName()));
            LOGGER.debug((Object)("Adding " + sub.getName() + " to sub-partition of " + supi.getName()));
            suppart = new Partition(sub);
            this._partitionMap.put(supi, suppart);
        } else {
            LOGGER.debug((Object)("Adding " + sub.getName() + " to sub-partition of " + supi.getName()));
            suppart.addConcept(sub);
        }
    }

    public static class Factory
    implements ShadowLookupExtensionFactory {
        public String getCategory() {
            return "de.renew.formalism.fs";
        }

        public ShadowLookupExtension createExtension() {
            return new FSShadowLookupExtension();
        }
    }
}

