/*
 * Decompiled with CFR 0.152.
 */
package de.renew.formalism.fs;

import de.renew.expression.Function;
import de.renew.formalism.function.BasicFunction;
import de.renew.unify.Impossible;
import de.renew.unify.Tuple;
import de.renew.util.Value;
import de.uni_hamburg.fs.FeatureStructure;
import de.uni_hamburg.fs.UnificationFailure;

public abstract class FSFunction
implements Function {
    public static final FSFunction LESS = new FSFunction(){

        @Override
        public Object doFSFunction(FeatureStructure left, FeatureStructure right) {
            return new Value((Object)(!left.equals(right) && left.subsumes(right) ? 1 : 0));
        }

        @Override
        public Function getOrdFunction() {
            return BasicFunction.LESS;
        }
    };
    public static final FSFunction LESSEQUAL = new FSFunction(){

        @Override
        public Object doFSFunction(FeatureStructure left, FeatureStructure right) {
            return new Value((Object)left.subsumes(right));
        }

        @Override
        public Function getOrdFunction() {
            return BasicFunction.LESSEQUAL;
        }
    };
    public static final FSFunction GREATER = new FSFunction(){

        @Override
        public Object doFSFunction(FeatureStructure left, FeatureStructure right) {
            return new Value((Object)(!left.equals(right) && right.subsumes(left) ? 1 : 0));
        }

        @Override
        public Function getOrdFunction() {
            return BasicFunction.GREATER;
        }
    };
    public static final FSFunction GREATEREQUAL = new FSFunction(){

        @Override
        public Object doFSFunction(FeatureStructure left, FeatureStructure right) {
            return new Value((Object)right.subsumes(left));
        }

        @Override
        public Function getOrdFunction() {
            return BasicFunction.GREATEREQUAL;
        }
    };
    public static final FSFunction PLUS = new FSFunction(){

        @Override
        public Object doFSFunction(FeatureStructure left, FeatureStructure right) throws Impossible {
            try {
                return left.unify(right);
            }
            catch (UnificationFailure uff) {
                throw new Impossible();
            }
        }

        @Override
        public Function getOrdFunction() {
            return BasicFunction.PLUS;
        }
    };

    public abstract Object doFSFunction(FeatureStructure var1, FeatureStructure var2) throws Impossible;

    public abstract Function getOrdFunction();

    public Object function(Object param) throws Impossible {
        Tuple tuple = (Tuple)param;
        if (tuple.getArity() != 2) {
            throw new Impossible();
        }
        Object obj1 = tuple.getComponent(0);
        Object obj2 = tuple.getComponent(1);
        if (obj1 instanceof FeatureStructure && obj2 instanceof FeatureStructure) {
            FeatureStructure fs1 = (FeatureStructure)obj1;
            FeatureStructure fs2 = (FeatureStructure)obj2;
            return this.doFSFunction(fs1, fs2);
        }
        return this.getOrdFunction().function(param);
    }
}

