/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.words.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collector;
import net.automatalib.commons.util.collections.CollectionsUtil;
import net.automatalib.exception.GrowingAlphabetNotSupportedException;
import net.automatalib.words.Alphabet;
import net.automatalib.words.GrowingAlphabet;
import net.automatalib.words.impl.AlphabetCollector;
import net.automatalib.words.impl.ArrayAlphabet;
import net.automatalib.words.impl.EnumAlphabet;
import net.automatalib.words.impl.ListAlphabet;
import net.automatalib.words.impl.MapAlphabet;

public final class Alphabets {
    private Alphabets() {
    }

    @SafeVarargs
    public static <T> Alphabet<T> fromArray(T ... symbols) {
        return new ArrayAlphabet<T>(symbols);
    }

    public static <E extends Enum<E>> Alphabet<E> fromEnum(Class<E> enumClazz) {
        return Alphabets.fromEnum(enumClazz, false);
    }

    public static <E extends Enum<E>> Alphabet<E> fromEnum(Class<E> enumClazz, boolean withNull) {
        return new EnumAlphabet<E>(enumClazz, withNull);
    }

    public static Alphabet<Integer> integers(int startInclusive, int endInclusive) {
        List<Integer> lst = CollectionsUtil.intRange(startInclusive, endInclusive + 1);
        return Alphabets.fromList(lst);
    }

    public static <T> Alphabet<T> fromList(List<? extends T> list) {
        return new ListAlphabet<T>(list);
    }

    public static Alphabet<Character> characters(char startInclusive, char endInclusive) {
        List<Character> lst = CollectionsUtil.charRange(startInclusive, (char)(endInclusive + '\u0001'));
        return Alphabets.fromList(lst);
    }

    public static Alphabet<String> closedCharStringRange(char startInclusive, char endInclusive) {
        List<String> lst = CollectionsUtil.charStringRange(startInclusive, (char)(endInclusive + '\u0001'));
        return Alphabets.fromList(lst);
    }

    public static <T> Alphabet<T> singleton(T symbol) {
        return Alphabets.fromList(Collections.singletonList(symbol));
    }

    public static <I> Alphabet<I> fromCollection(Collection<? extends I> coll) {
        if (coll instanceof Alphabet) {
            return (Alphabet)coll;
        }
        return new MapAlphabet<I>(coll);
    }

    public static <I> GrowingAlphabet<I> toGrowingAlphabetOrThrowException(Alphabet<I> alphabet) {
        if (alphabet instanceof GrowingAlphabet) {
            return (GrowingAlphabet)alphabet;
        }
        throw new GrowingAlphabetNotSupportedException(alphabet);
    }

    public static <I> Collector<I, ?, GrowingAlphabet<I>> collector() {
        return new AlphabetCollector();
    }
}

