/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.partitionrefinement;

import java.util.Arrays;
import java.util.Iterator;
import java.util.PrimitiveIterator;
import java.util.Spliterator;
import java.util.Spliterators;
import net.automatalib.util.partitionrefinement.Block;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PaigeTarjan {
    public int numInputs;
    public int numStates;
    public int[] blockData;
    public int[] posData;
    public int posDataLow;
    public int[] predOfsData;
    public int predOfsDataLow;
    public int[] predData;
    public Block[] blockForState;
    private @Nullable Block blocklistHead;
    private int numBlocks;
    private @Nullable Block worklistHead;
    private @Nullable Block worklistTail;
    private @Nullable Block touchedHead;

    public void setSize(int numStates, int numInputs) {
        this.numStates = numStates;
        this.numInputs = numInputs;
    }

    public void setBlockForState(Block[] blockForState) {
        this.blockForState = blockForState;
    }

    public void setBlockData(int[] blockData) {
        this.blockData = blockData;
    }

    public void setPosData(int[] posData, int posDataLow) {
        this.posData = posData;
        this.posDataLow = posDataLow;
    }

    public void setPredOfsData(int[] predOfsData, int predOfsDataLow) {
        this.predOfsData = predOfsData;
        this.predOfsDataLow = predOfsDataLow;
    }

    public void setPredData(int[] predData) {
        this.predData = predData;
    }

    public void removeEmptyBlocks() {
        Block curr = this.blocklistHead;
        Block prev = null;
        int effId = 0;
        while (curr != null) {
            if (!curr.isEmpty()) {
                curr.id = effId++;
                if (prev != null) {
                    prev.nextBlock = curr;
                } else {
                    this.blocklistHead = curr;
                }
                prev = curr;
            }
            curr = curr.nextBlock;
        }
        if (prev != null) {
            prev.nextBlock = null;
        } else {
            this.blocklistHead = null;
        }
        this.numBlocks = effId;
    }

    public void initBlockForStateMap() {
        this.blockForState = this.createBlockForStateMap();
    }

    public Block[] createBlockForStateMap() {
        Block[] map = new Block[this.numStates];
        Block b = this.blocklistHead;
        while (b != null) {
            int low = b.low;
            int high = b.high;
            for (int i = low; i < high; ++i) {
                int state = this.blockData[i];
                map[state] = b;
            }
            b = b.nextBlock;
        }
        return map;
    }

    public void initWorklist(boolean addAll) {
        if (addAll) {
            Block last = null;
            Block b = this.blocklistHead;
            while (b != null) {
                b.nextInWorklist = b.nextBlock;
                last = b;
                b = b.nextBlock;
            }
            this.worklistHead = this.blocklistHead;
            this.worklistTail = last;
        } else {
            Block largest = this.blocklistHead;
            if (largest == null) {
                return;
            }
            int largestSize = largest.size();
            Block b = largest.nextBlock;
            while (b != null) {
                int size = b.size();
                if (size > largestSize) {
                    this.addToWorklist(largest);
                    largest = b;
                    largestSize = size;
                } else {
                    this.addToWorklist(b);
                }
                b = b.nextBlock;
            }
        }
    }

    private void addToWorklist(Block b) {
        if (this.worklistHead == null) {
            this.worklistHead = b;
            this.worklistTail = b;
        } else {
            assert (this.worklistTail != null);
            this.worklistTail.nextInWorklist = b;
            this.worklistTail = b;
        }
    }

    public void computeCoarsestStablePartition() {
        Block curr;
        while ((curr = this.poll()) != null) {
            int blockRange = curr.high - curr.low;
            int[] blockCopy = new int[blockRange];
            System.arraycopy(this.blockData, curr.low, blockCopy, 0, blockRange);
            int predOfsBase = this.predOfsDataLow;
            for (int i = 0; i < this.numInputs; ++i) {
                for (int j = 0; j < blockRange; ++j) {
                    int state = blockCopy[j];
                    int predOfsIdx = predOfsBase + state;
                    int predLow = this.predOfsData[predOfsIdx];
                    int predHigh = this.predOfsData[predOfsIdx + 1];
                    for (int k = predLow; k < predHigh; ++k) {
                        int pred = this.predData[k];
                        this.moveLeft(pred);
                    }
                }
                predOfsBase += this.numStates;
                this.processTouched();
            }
        }
    }

    private @Nullable Block poll() {
        if (this.worklistHead == null) {
            return null;
        }
        Block b = this.worklistHead;
        this.worklistHead = b.nextInWorklist;
        b.nextInWorklist = null;
        if (this.worklistHead == null) {
            this.worklistTail = null;
        }
        return b;
    }

    private void moveLeft(int state) {
        Block b = this.blockForState[state];
        int posIdx = this.posDataLow + state;
        int inBlockIdx = this.posData[posIdx];
        int ptr = b.ptr;
        if (ptr == -1) {
            b.nextTouched = this.touchedHead;
            this.touchedHead = b;
            b.ptr = ptr = b.low;
        }
        if (ptr <= inBlockIdx) {
            if (ptr < inBlockIdx) {
                int other = this.blockData[ptr];
                this.blockData[ptr] = this.blockData[inBlockIdx];
                this.blockData[inBlockIdx] = other;
                this.posData[posIdx] = ptr;
                this.posData[this.posDataLow + other] = inBlockIdx;
            }
            b.ptr = ++ptr;
        }
    }

    private void processTouched() {
        Block b = this.touchedHead;
        while (b != null) {
            Block next = b.nextTouched;
            b.nextTouched = null;
            Block splt = this.split(b);
            if (splt != null) {
                this.addToWorklist(splt);
            }
            b.ptr = -1;
            b = next;
        }
        this.touchedHead = null;
    }

    private @Nullable Block split(Block b) {
        Block splt = b.split(this.numBlocks);
        if (splt == null) {
            return null;
        }
        ++this.numBlocks;
        int spltLow = splt.low;
        int spltHigh = splt.high;
        for (int i = spltLow; i < spltHigh; ++i) {
            int state = this.blockData[i];
            this.blockForState[state] = splt;
        }
        return splt;
    }

    public Block createBlock() {
        Block b;
        this.blocklistHead = b = new Block(-1, -1, this.numBlocks++, this.blocklistHead);
        return b;
    }

    public Block getBlockForState(int id) {
        return this.blockForState[id];
    }

    public int getRepresentative(Block b) {
        return this.blockData[b.low];
    }

    public PrimitiveIterator.OfInt statesInBlockIterator(Block b) {
        return Spliterators.iterator(this.statesInBlockSpliterator(b));
    }

    public Spliterator.OfInt statesInBlockSpliterator(Block b) {
        return Arrays.spliterator(this.blockData, b.low, b.high);
    }

    public Iterator<Block> blockListIterator() {
        return Block.blockListIterator(this.blocklistHead);
    }

    public Iterable<Block> blockList() {
        return this::blockListIterator;
    }

    public int getNumBlocks() {
        return this.numBlocks;
    }

    public static enum WorklistPolicy {
        FIFO,
        LIFO;

    }
}

