/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.automata.cover;

import com.google.common.collect.AbstractIterator;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import java.util.Queue;
import net.automatalib.automata.DeterministicAutomaton;
import net.automatalib.commons.util.mappings.MutableMapping;
import net.automatalib.util.automata.cover.Covers;
import net.automatalib.util.automata.cover.Record;
import net.automatalib.words.Word;
import org.checkerframework.checker.nullness.qual.Nullable;

class IncrementalStateCoverIterator<S, I>
extends AbstractIterator<Word<I>> {
    private final DeterministicAutomaton<S, I, ?> automaton;
    private final Collection<? extends I> inputs;
    private final Collection<? extends Word<I>> oldCover;
    private final MutableMapping<S, @Nullable Record<S, I>> reach;
    private final Queue<Record<S, I>> bfsQueue;
    private Iterator<? extends I> inputIterator;
    private Record<S, I> curr;

    IncrementalStateCoverIterator(DeterministicAutomaton<S, I, ?> automaton, Collection<? extends I> inputs, Collection<? extends Word<I>> oldCover) {
        this.automaton = automaton;
        this.inputs = inputs;
        this.oldCover = oldCover;
        this.reach = automaton.createStaticStateMapping();
        this.bfsQueue = new ArrayDeque<Record<S, I>>();
    }

    @Override
    protected Word<I> computeNext() {
        if (this.inputIterator == null) {
            boolean hasEpsilon = this.initialize();
            this.curr = this.bfsQueue.poll();
            this.inputIterator = this.inputs.iterator();
            if (!hasEpsilon) {
                return Word.epsilon();
            }
        }
        while (this.curr != null) {
            Object state = this.curr.state;
            Word<I> as = this.curr.accessSequence;
            while (this.inputIterator.hasNext()) {
                I in = this.inputIterator.next();
                Object succ = this.automaton.getSuccessor(state, in);
                if (succ == null || this.reach.get(succ) != null) continue;
                Word succAs = as.append(in);
                Record succRec = new Record(succ, succAs);
                this.reach.put(succ, succRec);
                this.bfsQueue.add(succRec);
                return succAs;
            }
            this.curr = this.bfsQueue.poll();
            this.inputIterator = this.inputs.iterator();
        }
        return (Word)this.endOfData();
    }

    private boolean initialize() {
        Object init = this.automaton.getInitialState();
        if (init == null) {
            this.endOfData();
            return false;
        }
        Covers.buildReachFromStateCover(this.reach, this.bfsQueue, this.automaton, this.oldCover, Record::new);
        if (this.reach.get(init) == null) {
            Record rec = new Record(init, Word.epsilon());
            this.reach.put(init, rec);
            this.bfsQueue.add(rec);
            return false;
        }
        return true;
    }
}

