/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.ts.simple;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import net.automatalib.ts.simple.SimpleTS;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface SimpleDTS<S, I>
extends SimpleTS<S, I> {
    @Override
    default public Set<S> getSuccessors(S state, Iterable<? extends I> input) {
        return SimpleDTS.stateToSet(this.getSuccessor(state, (I)input));
    }

    @Override
    default public Set<S> getSuccessors(S state, I input) {
        return SimpleDTS.stateToSet(this.getSuccessor(state, input));
    }

    @Override
    default public Set<S> getStates(Iterable<? extends I> input) {
        return SimpleDTS.stateToSet(this.getState(input));
    }

    @Override
    default public Set<S> getInitialStates() {
        return SimpleDTS.stateToSet(this.getInitialState());
    }

    default public @Nullable S getState(Iterable<? extends I> input) {
        S init = this.getInitialState();
        return init == null ? null : (S)this.getSuccessor(init, (I)input);
    }

    public @Nullable S getInitialState();

    public static <S> Set<S> stateToSet(@Nullable S state) {
        if (state == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(state);
    }

    default public @Nullable S getSuccessor(S state, Iterable<? extends I> input) {
        S curr = state;
        Iterator<I> it = input.iterator();
        while (curr != null && it.hasNext()) {
            I sym = it.next();
            curr = this.getSuccessor(curr, sym);
        }
        return curr;
    }

    public @Nullable S getSuccessor(S var1, I var2);
}

