/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.ts.output;

import java.util.List;
import net.automatalib.automata.concepts.TransitionOutput;
import net.automatalib.ts.output.DeterministicOutputTS;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface DeterministicTransitionOutputTS<S, I, T, O>
extends DeterministicOutputTS<S, I, T, O>,
TransitionOutput<T, O> {
    default public @Nullable O getOutput(S state, I input) {
        Object trans = this.getTransition(state, input);
        if (trans == null) {
            return null;
        }
        return this.getTransitionOutput(trans);
    }

    @Override
    default public boolean trace(S state, Iterable<? extends I> input, List<? super O> output) {
        S iter = state;
        for (I sym : input) {
            Object trans = this.getTransition(iter, sym);
            if (trans == null) {
                return false;
            }
            Object out = this.getTransitionOutput(trans);
            output.add(out);
            iter = this.getSuccessor(trans);
        }
        return true;
    }
}

