/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.serialization.saf;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.automatalib.automata.UniversalAutomaton;
import net.automatalib.automata.fsa.DFA;
import net.automatalib.automata.fsa.NFA;
import net.automatalib.commons.util.IOUtil;
import net.automatalib.serialization.saf.AcceptanceEncoder;
import net.automatalib.serialization.saf.AutomatonType;
import net.automatalib.serialization.saf.BlockPropertyEncoder;
import net.automatalib.serialization.saf.SinglePropertyEncoder;
import net.automatalib.words.Alphabet;

public class SAFOutput {
    private final DataOutput out;

    SAFOutput(OutputStream os) {
        this(new DataOutputStream(os));
    }

    SAFOutput(DataOutput out) {
        this.out = out;
    }

    SAFOutput(File file) throws IOException {
        this(IOUtil.asBufferedOutputStream(file));
    }

    public <I> void writeDFA(DFA<?, I> automaton, Alphabet<I> alphabet) throws IOException {
        this.writeAutomaton(automaton, alphabet, AutomatonType.DFA, new AcceptanceEncoder(), SinglePropertyEncoder.nullEncoder());
    }

    public <I, SP, TP> void writeAutomaton(UniversalAutomaton<?, I, ?, SP, TP> source, Alphabet<I> alphabet, AutomatonType expectedType, BlockPropertyEncoder<? super SP> spEncoder, SinglePropertyEncoder<? super TP> tpEncoder) throws IOException {
        this.writeHeader(expectedType);
        this.out.writeInt(alphabet.size());
        this.writeAutomatonBody(source, alphabet, expectedType.isDeterministic(), spEncoder, tpEncoder);
    }

    public void writeHeader(AutomatonType type) throws IOException {
        this.out.writeByte(83);
        this.out.writeByte(65);
        this.out.writeByte(70);
        this.out.writeByte(type.ordinal());
    }

    private <I, SP, TP> void writeAutomatonBody(UniversalAutomaton<?, I, ?, SP, TP> automaton, Alphabet<I> alphabet, boolean deterministic, BlockPropertyEncoder<? super SP> spDecoder, SinglePropertyEncoder<? super TP> tpDecoder) throws IOException {
        int numStates = automaton.size();
        this.out.writeInt(numStates);
        if (deterministic) {
            this.encodeBodyDet(automaton, alphabet, spDecoder, tpDecoder);
        } else {
            this.encodeBodyNondet(automaton, alphabet, spDecoder, tpDecoder);
        }
    }

    private <S, I, SP, TP> void encodeBodyDet(UniversalAutomaton<S, I, ?, SP, TP> result, Alphabet<I> alphabet, BlockPropertyEncoder<? super SP> spEncoder, SinglePropertyEncoder<? super TP> tpEncoder) throws IOException {
        Set initials = result.getInitialStates();
        if (initials.size() != 1) {
            throw new IllegalArgumentException();
        }
        ArrayList states = new ArrayList(result.getStates());
        Object init = initials.iterator().next();
        this.encodeStatesDet(result, init, states, spEncoder);
        this.encodeTransitionsDet(result, alphabet, states, tpEncoder);
    }

    private <S, I, SP, TP> void encodeBodyNondet(UniversalAutomaton<S, I, ?, SP, TP> source, Alphabet<I> alphabet, BlockPropertyEncoder<? super SP> spEncoder, SinglePropertyEncoder<? super TP> tpEncoder) throws IOException {
        ArrayList states = new ArrayList(source.getStates());
        Set initials = source.getInitialStates();
        this.encodeStatesNondet(source, initials, states, spEncoder);
        this.encodeTransitionsNondet(source, alphabet, states, tpEncoder);
    }

    private <S, SP> void encodeStatesDet(UniversalAutomaton<S, ?, ?, SP, ?> source, S init, List<S> states, BlockPropertyEncoder<? super SP> encoder) throws IOException {
        this.out.writeInt(states.indexOf(init));
        this.encodeStateProperties(source, states, encoder);
    }

    private <S, I, T, TP> void encodeTransitionsDet(UniversalAutomaton<S, I, T, ?, TP> source, Alphabet<I> alphabet, List<S> stateList, SinglePropertyEncoder<? super TP> tpEncoder) throws IOException {
        for (S state : stateList) {
            for (int j = 0; j < alphabet.size(); ++j) {
                I sym = alphabet.getSymbol(j);
                Collection succs = source.getTransitions(state, sym);
                if (succs.size() > 1) {
                    throw new IllegalArgumentException("Not deterministic");
                }
                if (succs.isEmpty()) {
                    this.out.writeInt(-1);
                    continue;
                }
                Object succ = succs.iterator().next();
                Object succState = source.getSuccessor(succ);
                assert (succState != null);
                int tgt = stateList.indexOf(succState);
                this.out.writeInt(tgt);
                tpEncoder.writeProperty(this.out, source.getTransitionProperty(succ));
            }
        }
    }

    private <S, SP> void encodeStatesNondet(UniversalAutomaton<S, ?, ?, SP, ?> source, Collection<? extends S> initialStates, List<S> states, BlockPropertyEncoder<? super SP> encoder) throws IOException {
        this.out.writeInt(initialStates.size());
        for (S s2 : initialStates) {
            this.out.writeInt(states.indexOf(s2));
        }
        this.encodeStateProperties(source, states, encoder);
    }

    private <S, I, T, TP> void encodeTransitionsNondet(UniversalAutomaton<S, I, T, ?, TP> source, Alphabet<I> alphabet, List<S> stateList, SinglePropertyEncoder<? super TP> tpEncoder) throws IOException {
        for (S state : stateList) {
            for (int j = 0; j < alphabet.size(); ++j) {
                I sym = alphabet.getSymbol(j);
                Collection succs = source.getTransitions(state, sym);
                this.out.writeInt(succs.size());
                for (Object t : succs) {
                    Object succState = source.getSuccessor(t);
                    this.out.writeInt(stateList.indexOf(succState));
                    tpEncoder.writeProperty(this.out, source.getTransitionProperty(t));
                }
            }
        }
    }

    private <S, SP> void encodeStateProperties(UniversalAutomaton<S, ?, ?, SP, ?> source, List<S> states, BlockPropertyEncoder<? super SP> encoder) throws IOException {
        encoder.start(this.out);
        for (S s2 : states) {
            encoder.encodeProperty(this.out, source.getStateProperty(s2));
        }
        encoder.finish(this.out);
    }

    public <I> void writeNFA(NFA<?, I> automaton, Alphabet<I> alphabet) throws IOException {
        this.writeAutomaton(automaton, alphabet, AutomatonType.NFA, new AcceptanceEncoder(), SinglePropertyEncoder.nullEncoder());
    }
}

