/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.incremental.mealy.tree;

import java.io.Serializable;
import net.automatalib.commons.smartcollections.ResizingArrayStorage;
import net.automatalib.incremental.mealy.tree.Edge;
import org.checkerframework.checker.nullness.qual.Nullable;

final class Node<O>
implements Serializable {
    private final ResizingArrayStorage<Edge<Node<O>, O>> outEdges;

    Node(int alphabetSize) {
        this.outEdges = new ResizingArrayStorage<Edge>(Edge.class, alphabetSize);
    }

    Edge<Node<O>, O> getEdge(int idx) {
        return ((Edge[])this.outEdges.array)[idx];
    }

    void setEdge(int idx, Edge<Node<O>, O> edge) {
        ((Edge[])this.outEdges.array)[idx] = edge;
    }

    @Nullable Node<O> getSuccessor(int idx) {
        Edge edge = ((Edge[])this.outEdges.array)[idx];
        if (edge != null) {
            return (Node)edge.getTarget();
        }
        return null;
    }

    boolean ensureInputCapacity(int capacity) {
        return this.outEdges.ensureCapacity(capacity);
    }
}

