/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.incremental.mealy.tree;

import com.google.common.base.Objects;
import com.google.common.collect.Iterators;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.automatalib.automata.transducers.MealyMachine;
import net.automatalib.incremental.ConflictException;
import net.automatalib.incremental.mealy.AbstractIncrementalMealyBuilder;
import net.automatalib.incremental.mealy.tree.AnnotatedEdge;
import net.automatalib.incremental.mealy.tree.Edge;
import net.automatalib.ts.output.MealyTransitionSystem;
import net.automatalib.util.graphs.traversal.GraphTraversal;
import net.automatalib.visualization.VisualizationHelper;
import net.automatalib.visualization.helper.DelegateVisualizationHelper;
import net.automatalib.words.Word;
import net.automatalib.words.WordBuilder;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AbstractIncrementalMealyTreeBuilder<N, I, O>
extends AbstractIncrementalMealyBuilder<I, O> {
    protected final N root;

    public AbstractIncrementalMealyTreeBuilder(N root) {
        this.root = root;
    }

    @Override
    public boolean lookup(Word<? extends I> word, List<? super O> output) {
        N curr = this.root;
        for (I sym : word) {
            Edge<N, O> edge = this.getEdge(curr, sym);
            if (edge == null) {
                return false;
            }
            output.add(edge.getOutput());
            curr = edge.getTarget();
        }
        return true;
    }

    @Override
    public void insert(Word<? extends I> input, Word<? extends O> outputWord) {
        N curr = this.root;
        Iterator<O> outputIt = outputWord.iterator();
        for (I sym : input) {
            O out = outputIt.next();
            Edge<N, O> edge = this.getEdge(curr, sym);
            if (edge == null) {
                curr = this.insertNode(curr, sym, out);
                continue;
            }
            if (!Objects.equal(out, edge.getOutput())) {
                throw new ConflictException();
            }
            curr = edge.getTarget();
        }
    }

    @Override
    public GraphView asGraph() {
        return new GraphView();
    }

    @Override
    public TransitionSystemView asTransitionSystem() {
        return new TransitionSystemView();
    }

    @Override
    public @Nullable Word<I> findSeparatingWord(MealyMachine<?, I, ?, O> target, Collection<? extends I> inputs, boolean omitUndefined) {
        return this.doFindSeparatingWord(target, inputs, omitUndefined);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private <S, T> @Nullable Word<I> doFindSeparatingWord(MealyMachine<S, I, T, O> target, Collection<? extends I> inputs, boolean omitUndefined) {
        ArrayDeque<Record<@Nullable S, Object, ? extends I>> dfsStack = new ArrayDeque();
        Record<@Nullable S, N, ? extends I> init = new Record(target.getInitialState(), this.root, null, inputs.iterator());
        dfsStack.push(init);
        while (!dfsStack.isEmpty()) {
            Object trans;
            @Nullable @NonNull Record rec = (Record)dfsStack.peek();
            if (!rec.inputIt.hasNext()) {
                dfsStack.pop();
                continue;
            }
            Object input = rec.inputIt.next();
            Edge<Object, O> edge = this.getEdge(rec.treeNode, input);
            if (edge == null) continue;
            Object state = rec.automatonState;
            Object t = trans = state == null ? null : (Object)target.getTransition(state, input);
            if (omitUndefined && trans == null) continue;
            if (trans == null || !Objects.equal(target.getTransitionOutput(trans), edge.getOutput())) {
                WordBuilder<Object> wb = new WordBuilder<Object>(dfsStack.size());
                wb.append(input);
                dfsStack.pop();
                while (!dfsStack.isEmpty()) {
                    wb.append(rec.incomingInput);
                    rec = (Record)dfsStack.pop();
                }
                return wb.reverse().toWord();
            }
            Record<@Nullable S, Object, ? extends I> nextRecord = new Record(target.getSuccessor(trans), edge.getTarget(), input, inputs.iterator());
            dfsStack.push(nextRecord);
        }
        return null;
    }

    protected abstract @Nullable Edge<N, O> getEdge(N var1, I var2);

    protected abstract N createNode();

    protected abstract N insertNode(N var1, I var2, O var3);

    protected abstract Collection<AnnotatedEdge<N, I, O>> getOutgoingEdges(N var1);

    public class TransitionSystemView
    implements MealyTransitionSystem<N, I, Edge<N, O>, O> {
        @Override
        public @Nullable Edge<N, O> getTransition(N state, I input) {
            return AbstractIncrementalMealyTreeBuilder.this.getEdge(state, input);
        }

        @Override
        public N getSuccessor(Edge<N, O> transition) {
            return transition.getTarget();
        }

        @Override
        public N getInitialState() {
            return AbstractIncrementalMealyTreeBuilder.this.root;
        }

        @Override
        public O getTransitionOutput(Edge<N, O> transition) {
            return transition.getOutput();
        }
    }

    public class GraphView
    extends AbstractIncrementalMealyBuilder.AbstractGraphView<I, O, N, AnnotatedEdge<N, I, O>> {
        @Override
        public Collection<N> getNodes() {
            ArrayList result = new ArrayList();
            Iterators.addAll(result, GraphTraversal.dfIterator(this, Collections.singleton(AbstractIncrementalMealyTreeBuilder.this.root)));
            return result;
        }

        @Override
        public Collection<AnnotatedEdge<N, I, O>> getOutgoingEdges(N node) {
            return AbstractIncrementalMealyTreeBuilder.this.getOutgoingEdges(node);
        }

        @Override
        public N getTarget(AnnotatedEdge<N, I, O> edge) {
            return edge.getTarget();
        }

        @Override
        public I getInputSymbol(AnnotatedEdge<N, I, O> edge) {
            return edge.getInput();
        }

        @Override
        public O getOutputSymbol(AnnotatedEdge<N, I, O> edge) {
            return edge.getOutput();
        }

        @Override
        public N getInitialNode() {
            return AbstractIncrementalMealyTreeBuilder.this.root;
        }

        @Override
        public VisualizationHelper<N, AnnotatedEdge<N, I, O>> getVisualizationHelper() {
            return new DelegateVisualizationHelper<N, AnnotatedEdge<N, I, O>>(super.getVisualizationHelper()){
                private int id;

                @Override
                public boolean getNodeProperties(N node, Map<String, String> properties) {
                    if (!super.getNodeProperties(node, properties)) {
                        return false;
                    }
                    properties.put("label", "n" + this.id++);
                    return true;
                }
            };
        }
    }

    private static final class Record<S, N, I> {
        private final S automatonState;
        private final N treeNode;
        private final I incomingInput;
        private final Iterator<? extends I> inputIt;

        Record(S automatonState, N treeNode, I incomingInput, Iterator<? extends I> inputIt) {
            this.automatonState = automatonState;
            this.treeNode = treeNode;
            this.inputIt = inputIt;
            this.incomingInput = incomingInput;
        }
    }
}

