/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.commons.util.collections;

import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;

public final class IntRangeIterator
implements ListIterator<Integer>,
PrimitiveIterator.OfInt {
    private final int low;
    private final int step;
    private final int size;
    private int curr;

    public IntRangeIterator(int low, int step, int size) {
        this(low, step, size, 0);
    }

    public IntRangeIterator(int low, int step, int size, int startIdx) {
        this.low = low;
        this.size = size;
        this.step = step;
        this.curr = startIdx;
    }

    private int intValue(int idx) {
        return this.low + this.step * idx;
    }

    @Override
    public boolean hasNext() {
        return this.curr < this.size;
    }

    @Override
    public int nextInt() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.intValue(this.curr++);
    }

    @Override
    public Integer next() {
        return PrimitiveIterator.OfInt.super.next();
    }

    @Override
    public boolean hasPrevious() {
        return this.curr > 0;
    }

    @Override
    public Integer previous() {
        return this.previousInt();
    }

    public int previousInt() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        return this.intValue(--this.curr);
    }

    @Override
    public int nextIndex() {
        return this.hasNext() ? this.curr : this.size;
    }

    @Override
    public int previousIndex() {
        return this.hasPrevious() ? this.curr - 1 : -1;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(Integer e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(Integer e) {
        throw new UnsupportedOperationException();
    }
}

