/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.commons.util;

import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;
import net.automatalib.commons.util.strings.AbstractPrintable;
import net.automatalib.commons.util.strings.StringUtil;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class Triple<T1, T2, T3>
extends AbstractPrintable
implements Serializable {
    private static final long serialVersionUID = -1L;
    private final T1 first;
    private final T2 second;
    private final T3 third;

    private Triple(T1 first, T2 second, T3 third) {
        this.first = first;
        this.second = second;
        this.third = third;
    }

    public static <T1, T2, T3> Triple<T1, T2, T3> of(T1 first, T2 second, T3 third) {
        return new Triple<T1, T2, T3>(first, second, third);
    }

    public T1 getFirst() {
        return this.first;
    }

    public T2 getSecond() {
        return this.second;
    }

    public T3 getThird() {
        return this.third;
    }

    @Override
    public void print(Appendable a) throws IOException {
        StringUtil.appendObject(a, this.first);
        a.append(", ");
        StringUtil.appendObject(a, this.second);
        a.append(", ");
        StringUtil.appendObject(a, this.third);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Triple)) {
            return false;
        }
        Triple that = (Triple)o;
        return Objects.equals(this.first, that.first) && Objects.equals(this.second, that.second) && Objects.equals(this.third, that.third);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.first);
        result = 31 * result + Objects.hashCode(this.second);
        result = 31 * result + Objects.hashCode(this.third);
        return result;
    }
}

