/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automata.helpers;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.automatalib.automata.concepts.StateIDs;
import net.automatalib.automata.simple.SimpleAutomaton;

public class SimpleStateIDs<S>
implements StateIDs<S> {
    private final Map<S, Integer> stateIds;
    private final List<S> states;

    public SimpleStateIDs(SimpleAutomaton<S, ?> automaton) {
        this.states = new ArrayList<S>(automaton.getStates());
        int numStates = this.states.size();
        this.stateIds = Maps.newHashMapWithExpectedSize(numStates);
        for (int i = 0; i < numStates; ++i) {
            S state = this.states.get(i);
            this.stateIds.put(state, i);
        }
    }

    @Override
    public int getStateId(S state) {
        Integer id = this.stateIds.get(state);
        if (id == null) {
            throw new IllegalArgumentException();
        }
        return id;
    }

    @Override
    public S getState(int id) {
        return this.states.get(id);
    }
}

