/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automata;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import net.automatalib.automata.UniversalAutomaton;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface MutableAutomaton<S, I, T, SP, TP>
extends UniversalAutomaton<S, I, T, SP, TP> {
    public void clear();

    default public S addState() {
        return this.addState(null);
    }

    public S addState(@Nullable SP var1);

    default public S addInitialState() {
        return this.addInitialState(null);
    }

    default public S addInitialState(@Nullable SP property) {
        S state = this.addState(property);
        this.setInitial(state, true);
        return state;
    }

    public void setInitial(S var1, boolean var2);

    public void setStateProperty(S var1, SP var2);

    public void setTransitionProperty(T var1, TP var2);

    default public void addTransitions(S state, I input, Collection<? extends T> transitions) {
        HashSet newTransitions = new HashSet(this.getTransitions(state, input));
        if (!newTransitions.addAll(transitions)) {
            return;
        }
        this.setTransitions(state, input, newTransitions);
    }

    public void setTransitions(S var1, I var2, Collection<? extends T> var3);

    default public void removeTransition(S state, I input, T transition) {
        HashSet transitions = new HashSet(this.getTransitions(state, input));
        if (!transitions.remove(transition)) {
            return;
        }
        this.setTransitions(state, input, transitions);
    }

    default public void removeAllTransitions(S state, I input) {
        this.setTransitions(state, input, Collections.emptySet());
    }

    public void removeAllTransitions(S var1);

    default public T addTransition(S state, I input, S successor, TP properties) {
        T trans = this.createTransition(successor, properties);
        this.addTransition(state, input, trans);
        return trans;
    }

    default public void addTransition(S state, I input, T transition) {
        HashSet transitions = new HashSet(this.getTransitions(state, input));
        if (!transitions.add(transition)) {
            return;
        }
        this.setTransitions(state, input, transitions);
    }

    public T createTransition(S var1, TP var2);

    default public T copyTransition(T trans, S succ) {
        Object property = this.getTransitionProperty(trans);
        return this.createTransition(succ, property);
    }
}

