/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automata;

import java.util.function.IntFunction;
import net.automatalib.automata.Automaton;
import net.automatalib.automata.simple.SimpleDeterministicAutomaton;
import net.automatalib.ts.DeterministicTransitionSystem;
import net.automatalib.words.Alphabet;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface DeterministicAutomaton<S, I, T>
extends Automaton<S, I, T>,
SimpleDeterministicAutomaton<S, I>,
DeterministicTransitionSystem<S, I, T> {
    @Override
    default public FullIntAbstraction<T> fullIntAbstraction(Alphabet<I> alphabet) {
        return this.fullIntAbstraction(alphabet.size(), alphabet);
    }

    @Override
    default public FullIntAbstraction<T> fullIntAbstraction(int numInputs, IntFunction<? extends I> symMapping) {
        return new FullIntAbstraction.DefaultAbstraction(this.stateIntAbstraction(), numInputs, symMapping);
    }

    default public StateIntAbstraction<I, T> stateIntAbstraction() {
        return new StateIntAbstraction.DefaultAbstraction(this);
    }

    public static interface FullIntAbstraction<T>
    extends IntAbstraction<T>,
    SimpleDeterministicAutomaton.FullIntAbstraction {
        @Override
        default public int getSuccessor(int state, int input) {
            T trans = this.getTransition(state, input);
            if (trans == null) {
                return -1;
            }
            return this.getIntSuccessor(trans);
        }

        public @Nullable T getTransition(int var1, int var2);

        public static class DefaultAbstraction<I, T, A extends StateIntAbstraction<I, T>>
        extends SimpleDeterministicAutomaton.FullIntAbstraction.DefaultAbstraction<I, A>
        implements FullIntAbstraction<T> {
            public DefaultAbstraction(A stateAbstraction, int numInputs, IntFunction<? extends I> symMapping) {
                super(stateAbstraction, numInputs, symMapping);
            }

            @Override
            public @Nullable T getTransition(int state, int input) {
                return ((StateIntAbstraction)this.stateAbstraction).getTransition(state, this.intToSym(input));
            }

            @Override
            public int getIntSuccessor(T transition) {
                return ((StateIntAbstraction)this.stateAbstraction).getIntSuccessor(transition);
            }
        }
    }

    public static interface StateIntAbstraction<I, T>
    extends IntAbstraction<T>,
    SimpleDeterministicAutomaton.StateIntAbstraction<I> {
        @Override
        default public int getSuccessor(int state, I input) {
            T trans = this.getTransition(state, input);
            if (trans == null) {
                return -1;
            }
            return this.getIntSuccessor(trans);
        }

        public @Nullable T getTransition(int var1, I var2);

        public static class DefaultAbstraction<S, I, T, A extends DeterministicAutomaton<S, I, T>>
        extends SimpleDeterministicAutomaton.StateIntAbstraction.DefaultAbstraction<S, I, A>
        implements StateIntAbstraction<I, T> {
            public DefaultAbstraction(A automaton) {
                super(automaton);
            }

            @Override
            public int getIntSuccessor(T transition) {
                return this.stateToInt(((DeterministicAutomaton)this.automaton).getSuccessor(transition));
            }

            @Override
            public @Nullable T getTransition(int state, I input) {
                return ((DeterministicAutomaton)this.automaton).getTransition(this.intToState(state), input);
            }
        }
    }

    public static interface IntAbstraction<T>
    extends SimpleDeterministicAutomaton.IntAbstraction {
        public int getIntSuccessor(T var1);
    }
}

