/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.renderers;

import com.google.common.base.Function;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.Context;
import edu.uci.ics.jung.visualization.Layer;
import edu.uci.ics.jung.visualization.RenderContext;
import edu.uci.ics.jung.visualization.renderers.Renderer;
import edu.uci.ics.jung.visualization.renderers.VertexLabelRenderer;
import edu.uci.ics.jung.visualization.transform.shape.GraphicsDecorator;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Map;

public class VertexLabelAsShapeRenderer<V, E>
implements Renderer.VertexLabel<V, E>,
Function<V, Shape> {
    protected Map<V, Shape> shapes = new HashMap<V, Shape>();
    protected RenderContext<V, E> rc;

    public VertexLabelAsShapeRenderer(RenderContext<V, E> rc) {
        this.rc = rc;
    }

    public Component prepareRenderer(RenderContext<V, E> rc, VertexLabelRenderer graphLabelRenderer, Object value, boolean isSelected, V vertex) {
        return rc.getVertexLabelRenderer().getVertexLabelRendererComponent(rc.getScreenDevice(), value, rc.getVertexFontTransformer().apply(vertex), isSelected, vertex);
    }

    @Override
    public void labelVertex(RenderContext<V, E> rc, Layout<V, E> layout, V v, String label) {
        Graph<V, E> graph = layout.getGraph();
        if (!rc.getVertexIncludePredicate().apply(Context.getInstance(graph, v))) {
            return;
        }
        GraphicsDecorator g2 = rc.getGraphicsContext();
        Component component = this.prepareRenderer(rc, rc.getVertexLabelRenderer(), label, rc.getPickedVertexState().isPicked(v), v);
        Dimension d = component.getPreferredSize();
        int h_offset = -d.width / 2;
        int v_offset = -d.height / 2;
        Point2D p = (Point2D)layout.apply(v);
        p = rc.getMultiLayerTransformer().transform(Layer.LAYOUT, p);
        int x = (int)p.getX();
        int y = (int)p.getY();
        g2.draw(component, rc.getRendererPane(), x + h_offset, y + v_offset, d.width, d.height, true);
        Dimension size = component.getPreferredSize();
        Rectangle bounds = new Rectangle(-size.width / 2 - 2, -size.height / 2 - 2, size.width + 4, size.height);
        this.shapes.put((Shape)v, bounds);
    }

    @Override
    public Shape apply(V v) {
        Component component = this.prepareRenderer(this.rc, this.rc.getVertexLabelRenderer(), this.rc.getVertexLabelTransformer().apply(v), this.rc.getPickedVertexState().isPicked(v), v);
        Dimension size = component.getPreferredSize();
        Rectangle bounds = new Rectangle(-size.width / 2 - 2, -size.height / 2 - 2, size.width + 4, size.height);
        return bounds;
    }

    @Override
    public Renderer.VertexLabel.Position getPosition() {
        return Renderer.VertexLabel.Position.CNTR;
    }

    @Override
    public Renderer.VertexLabel.Positioner getPositioner() {
        return new Renderer.VertexLabel.Positioner(){

            @Override
            public Renderer.VertexLabel.Position getPosition(float x, float y, Dimension d) {
                return Renderer.VertexLabel.Position.CNTR;
            }
        };
    }

    @Override
    public void setPosition(Renderer.VertexLabel.Position position) {
    }

    @Override
    public void setPositioner(Renderer.VertexLabel.Positioner positioner) {
    }
}

