/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.annotations;

import edu.uci.ics.jung.visualization.MultiLayerTransformer;
import edu.uci.ics.jung.visualization.RenderContext;
import edu.uci.ics.jung.visualization.VisualizationServer;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.annotations.Annotation;
import edu.uci.ics.jung.visualization.annotations.AnnotationManager;
import edu.uci.ics.jung.visualization.control.AbstractGraphMousePlugin;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import javax.swing.JComponent;
import javax.swing.JOptionPane;

public class AnnotatingGraphMousePlugin<V, E>
extends AbstractGraphMousePlugin
implements MouseListener,
MouseMotionListener {
    protected int additionalModifiers;
    protected RectangularShape rectangularShape = new Rectangle2D.Float();
    protected VisualizationServer.Paintable lensPaintable;
    protected AnnotationManager annotationManager;
    protected Color annotationColor = Color.cyan;
    protected Annotation.Layer layer = Annotation.Layer.LOWER;
    protected boolean fill;
    protected MultiLayerTransformer basicTransformer;
    protected RenderContext<V, E> rc;
    protected boolean added = false;

    public AnnotatingGraphMousePlugin(RenderContext<V, E> rc) {
        this(rc, 16, 17);
    }

    public AnnotatingGraphMousePlugin(RenderContext<V, E> rc, int selectionModifiers, int additionalModifiers) {
        super(selectionModifiers);
        this.rc = rc;
        this.basicTransformer = rc.getMultiLayerTransformer();
        this.additionalModifiers = additionalModifiers;
        this.lensPaintable = new LensPaintable();
        this.annotationManager = new AnnotationManager(rc);
        this.cursor = Cursor.getPredefinedCursor(12);
    }

    public Color getAnnotationColor() {
        return this.annotationColor;
    }

    public void setAnnotationColor(Color lensColor) {
        this.annotationColor = lensColor;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        VisualizationViewer vv = (VisualizationViewer)e.getSource();
        this.down = e.getPoint();
        if (!this.added) {
            vv.addPreRenderPaintable(this.annotationManager.getLowerAnnotationPaintable());
            vv.addPostRenderPaintable(this.annotationManager.getUpperAnnotationPaintable());
            this.added = true;
        }
        if (e.isPopupTrigger()) {
            String annotationString = JOptionPane.showInputDialog(vv, (Object)"Annotation:");
            if (annotationString != null && annotationString.length() > 0) {
                Point2D p = vv.getRenderContext().getMultiLayerTransformer().inverseTransform(this.down);
                Annotation<String> annotation = new Annotation<String>(annotationString, this.layer, this.annotationColor, this.fill, p);
                this.annotationManager.add(this.layer, annotation);
            }
        } else if (e.getModifiers() == this.additionalModifiers) {
            Annotation<?> annotation = this.annotationManager.getAnnotation(this.down);
            this.annotationManager.remove(annotation);
        } else if (e.getModifiers() == this.modifiers) {
            this.rectangularShape.setFrameFromDiagonal(this.down, this.down);
            vv.addPostRenderPaintable(this.lensPaintable);
        }
        vv.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        VisualizationViewer vv = (VisualizationViewer)e.getSource();
        if (e.isPopupTrigger()) {
            String annotationString = JOptionPane.showInputDialog(vv, (Object)"Annotation:");
            if (annotationString != null && annotationString.length() > 0) {
                Point2D p = vv.getRenderContext().getMultiLayerTransformer().inverseTransform(this.down);
                Annotation<String> annotation = new Annotation<String>(annotationString, this.layer, this.annotationColor, this.fill, p);
                this.annotationManager.add(this.layer, annotation);
            }
        } else if (e.getModifiers() == this.modifiers && this.down != null) {
            Point out = e.getPoint();
            RectangularShape arect = (RectangularShape)this.rectangularShape.clone();
            arect.setFrameFromDiagonal(this.down, out);
            Shape s2 = vv.getRenderContext().getMultiLayerTransformer().inverseTransform(arect);
            Annotation<Shape> annotation = new Annotation<Shape>(s2, this.layer, this.annotationColor, this.fill, out);
            this.annotationManager.add(this.layer, annotation);
        }
        this.down = null;
        vv.removePostRenderPaintable(this.lensPaintable);
        vv.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        VisualizationViewer vv = (VisualizationViewer)e.getSource();
        Point out = e.getPoint();
        if (e.getModifiers() == this.additionalModifiers) {
            this.rectangularShape.setFrameFromDiagonal(this.down, out);
        } else if (e.getModifiers() == this.modifiers) {
            this.rectangularShape.setFrameFromDiagonal(this.down, out);
        }
        this.rectangularShape.setFrameFromDiagonal(this.down, out);
        vv.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        JComponent c = (JComponent)e.getSource();
        c.setCursor(this.cursor);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        JComponent c = (JComponent)e.getSource();
        c.setCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    public RectangularShape getRectangularShape() {
        return this.rectangularShape;
    }

    public void setRectangularShape(RectangularShape rect) {
        this.rectangularShape = rect;
    }

    public Annotation.Layer getLayer() {
        return this.layer;
    }

    public void setLayer(Annotation.Layer layer) {
        this.layer = layer;
    }

    public boolean isFill() {
        return this.fill;
    }

    public void setFill(boolean fill) {
        this.fill = fill;
    }

    class LensPaintable
    implements VisualizationServer.Paintable {
        LensPaintable() {
        }

        @Override
        public void paint(Graphics g2) {
            Color oldColor = g2.getColor();
            g2.setColor(AnnotatingGraphMousePlugin.this.annotationColor);
            ((Graphics2D)g2).draw(AnnotatingGraphMousePlugin.this.rectangularShape);
            g2.setColor(oldColor);
        }

        @Override
        public boolean useTransform() {
            return false;
        }
    }
}

