/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.layout;

import com.google.common.base.Function;
import edu.uci.ics.jung.algorithms.layout.SpringLayout;
import edu.uci.ics.jung.graph.Graph;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.util.ConcurrentModificationException;

public class SpringLayout2<V, E>
extends SpringLayout<V, E> {
    protected int currentIteration;
    protected int averageCounter;
    protected int loopCountMax = 4;
    protected boolean done;
    protected Point2D averageDelta = new Point2D.Double();

    public SpringLayout2(Graph<V, E> g2) {
        super(g2);
    }

    public SpringLayout2(Graph<V, E> g2, Function<E, Integer> length_function) {
        super(g2, length_function);
    }

    @Override
    public void step() {
        super.step();
        ++this.currentIteration;
        this.testAverageDeltas();
    }

    private void testAverageDeltas() {
        double dx = this.averageDelta.getX();
        double dy = this.averageDelta.getY();
        if (Math.abs(dx) < 0.001 && Math.abs(dy) < 0.001) {
            this.done = true;
            System.err.println("done, dx=" + dx + ", dy=" + dy);
        }
        if (this.currentIteration > this.loopCountMax) {
            this.averageDelta.setLocation(0.0, 0.0);
            this.averageCounter = 0;
            this.currentIteration = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void moveNodes() {
        Dimension dimension = this.getSize();
        synchronized (dimension) {
            try {
                for (Object v : this.getGraph().getVertices()) {
                    SpringLayout.SpringVertexData vd;
                    if (this.isLocked(v) || (vd = (SpringLayout.SpringVertexData)this.springVertexData.getUnchecked(v)) == null) continue;
                    Object xyd = this.apply(v);
                    vd.dx += vd.repulsiondx + vd.edgedx;
                    vd.dy += vd.repulsiondy + vd.edgedy;
                    this.averageDelta.setLocation((this.averageDelta.getX() * (double)this.averageCounter + vd.dx) / (double)(this.averageCounter + 1), (this.averageDelta.getY() * (double)this.averageCounter + vd.dy) / (double)(this.averageCounter + 1));
                    ++this.averageCounter;
                    ((Point2D)xyd).setLocation(((Point2D)xyd).getX() + Math.max(-5.0, Math.min(5.0, vd.dx)), ((Point2D)xyd).getY() + Math.max(-5.0, Math.min(5.0, vd.dy)));
                    Dimension d = this.getSize();
                    int width = d.width;
                    int height = d.height;
                    if (((Point2D)xyd).getX() < 0.0) {
                        ((Point2D)xyd).setLocation(0.0, ((Point2D)xyd).getY());
                    } else if (((Point2D)xyd).getX() > (double)width) {
                        ((Point2D)xyd).setLocation(width, ((Point2D)xyd).getY());
                    }
                    if (((Point2D)xyd).getY() < 0.0) {
                        ((Point2D)xyd).setLocation(((Point2D)xyd).getX(), 0.0);
                        continue;
                    }
                    if (!(((Point2D)xyd).getY() > (double)height)) continue;
                    ((Point2D)xyd).setLocation(((Point2D)xyd).getX(), height);
                }
            }
            catch (ConcurrentModificationException cme) {
                this.moveNodes();
            }
        }
    }

    @Override
    public boolean done() {
        return this.done;
    }
}

