/*
 * Decompiled with CFR 0.152.
 */
package com.github.misberner.graphvizawtshapes.shapes;

import com.github.misberner.graphvizawtshapes.shapes.PathIteratorConcatenation;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;

public abstract class ShapeUtil {
    public static PathIterator concatPathIterators(Iterable<? extends PathIterator> pathIt) {
        return new PathIteratorConcatenation(pathIt);
    }

    public static PathIterator concatPathIterators(Iterable<? extends Shape> shapes, final AffineTransform at) {
        Function<Shape, PathIterator> getPathIterator = new Function<Shape, PathIterator>(){

            @Override
            public PathIterator apply(Shape s2) {
                return s2.getPathIterator(at);
            }
        };
        return ShapeUtil.concatPathIterators(Iterables.transform(shapes, getPathIterator));
    }

    public static PathIterator concatPathIterators(Iterable<? extends Shape> shapes, final AffineTransform at, final double flatness) {
        Function<Shape, PathIterator> getPathIterator = new Function<Shape, PathIterator>(){

            @Override
            public PathIterator apply(Shape s2) {
                return s2.getPathIterator(at, flatness);
            }
        };
        return ShapeUtil.concatPathIterators(Iterables.transform(shapes, getPathIterator));
    }
}

