/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.util;

import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.util.Animatable;
import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import org.apache.log4j.Logger;

public class Animator
implements Runnable {
    private static Logger logger = Logger.getLogger(Animator.class);
    private static final int MAX_DELAY = 62;
    private static final int MIN_DELAY = 15;
    private DrawingView fView;
    private Animatable fAnimatable;
    private boolean fIsRunning;

    public Animator(Animatable animatable, DrawingView view) {
        this.fView = view;
        this.fAnimatable = animatable;
    }

    public void end() {
        this.fAnimatable.animationStop();
        this.fIsRunning = false;
    }

    @Override
    public void run() {
        this.fIsRunning = true;
        this.fAnimatable.animationStart();
        Runnable nextStep = new Runnable(){

            @Override
            public void run() {
                Animator.this.fAnimatable.animationStep();
                Animator.this.fView.checkDamage();
            }
        };
        while (this.fIsRunning) {
            block6: {
                long tm = System.currentTimeMillis();
                try {
                    EventQueue.invokeAndWait(nextStep);
                }
                catch (InterruptedException e) {
                    break;
                }
                catch (InvocationTargetException e) {
                    logger.warn((Object)e.getMessage());
                    if (!logger.isDebugEnabled()) break block6;
                    logger.debug((Object)(Animator.class.getSimpleName() + ": " + String.valueOf(e)));
                }
            }
            try {
                Thread.sleep(Math.max(15L, (tm += 62L) - System.currentTimeMillis()));
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }
}

