/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.figures.PolyLineFigure;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.UndoableCommand;

public class SplineAttributeCommand
extends UndoableCommand {
    String fAttribute;
    int value;

    public SplineAttributeCommand(String name, String attributeName, int pvalue) {
        super(name);
        this.fAttribute = attributeName;
        this.value = pvalue;
    }

    @Override
    public boolean isExecutable() {
        if (!super.isExecutable()) {
            return false;
        }
        DrawingView view = this.getEditor().view();
        if (view.selectionCount() <= 0) {
            return false;
        }
        if (view.selectionCount() > 1) {
            return true;
        }
        return view.selectionElements().nextElement() instanceof PolyLineFigure;
    }

    @Override
    public boolean executeUndoable() {
        if (this.isExecutable()) {
            if (!super.isExecutable()) {
                return false;
            }
            DrawingView view = this.getEditor().view();
            Integer val = this.value;
            Integer spline = 1;
            FigureEnumeration k = view.selectionElements();
            while (k.hasMoreElements()) {
                Figure f = k.nextFigure();
                if (!(f instanceof PolyLineFigure)) continue;
                f.setAttribute("LineShape", spline);
                if (this.fAttribute.equals("standard")) {
                    f.setAttribute("BSplineSegments", 15);
                    f.setAttribute("BSplineDegree", 2);
                    continue;
                }
                f.setAttribute(this.fAttribute, val);
            }
            view.drawAll(view.getGraphics());
            return true;
        }
        return false;
    }
}

