/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.standard.LocatorHandle;
import CH.ifa.draw.standard.RelativeLocator;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

class SouthEastHandle
extends LocatorHandle {
    private float ratio = 1.0f;

    SouthEastHandle(Figure owner) {
        super(owner, RelativeLocator.southEast());
        if (owner.displayBox().width != 0) {
            this.ratio = (float)owner.displayBox().height / (float)owner.displayBox().width;
        }
    }

    @Override
    public void invokeStep(MouseEvent e, int x, int y, int anchorX, int anchorY, DrawingView view) {
        Rectangle r = this.owner().displayBox();
        int mx = Math.max(r.x, x);
        int my = Math.max(r.y, y);
        if (e.isControlDown() && this.ratio != 0.0f) {
            this.owner().displayBox(new Point(r.x, r.y), new Point(mx, mx - this.owner().displayBox().x + this.owner().displayBox().y));
        } else if (e.isShiftDown()) {
            this.owner().displayBox(new Point(r.x, r.y), new Point(mx, Math.max(r.y, Math.round((float)(x - r.x) * this.ratio + (float)r.y))));
        } else {
            this.owner().displayBox(new Point(r.x, r.y), new Point(mx, my));
        }
    }
}

