/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureSelection;
import CH.ifa.draw.standard.FigureTransferCommand;
import CH.ifa.draw.util.Clipboard;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.util.Enumeration;
import java.util.Vector;

public class PasteCommand
extends FigureTransferCommand {
    public PasteCommand(String name) {
        super(name);
    }

    @Override
    public boolean executeUndoable() {
        DrawingView view = this.getEditor().view();
        Point lastClick = view.lastClick();
        Point lastPosition = view.getCurrentMousePosition();
        FigureSelection selection = (FigureSelection)Clipboard.getClipboard().getContents();
        if (selection != null) {
            Vector<Figure> figures = selection.getData("CH.ifa.draw.Figures");
            if (figures.isEmpty()) {
                return false;
            }
            Rectangle r = this.bounds(figures.elements());
            view.clearSelection();
            if (lastPosition != null) {
                Point lastPositionTransformed = this.transformPoint(lastPosition, view);
                this.insertFigures(figures, lastPositionTransformed.x - r.x, lastPositionTransformed.y - r.y);
            } else {
                Point lastClickTransformed = this.transformPoint(lastClick, view);
                this.insertFigures(figures, lastClickTransformed.x - r.x, lastClickTransformed.y - r.y);
            }
            view.checkDamage();
            return true;
        }
        return false;
    }

    Rectangle bounds(Enumeration<Figure> k) {
        Rectangle r = k.nextElement().displayBox();
        while (k.hasMoreElements()) {
            r.add(k.nextElement().displayBox());
        }
        return r;
    }

    private Point transformPoint(Point p, DrawingView view) {
        AffineTransform affineTransform = view.getAffineTransform();
        try {
            affineTransform.inverseTransform(p, p);
        }
        catch (NoninvertibleTransformException e) {
            throw new RuntimeException(e);
        }
        return p;
    }
}

