/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureSelection;
import CH.ifa.draw.framework.UndoableCommand;
import CH.ifa.draw.standard.StandardDrawingView;
import CH.ifa.draw.util.Clipboard;
import java.util.Vector;

abstract class FigureTransferCommand
extends UndoableCommand {
    protected FigureTransferCommand(String name) {
        super(name);
    }

    protected void deleteSelection() {
        DrawingView view = this.getEditor().view();
        view.drawing().removeAll(view.selection());
        view.clearSelection();
    }

    protected void copySelection() {
        FigureSelection selection = this.getEditor().view().getFigureSelection();
        Clipboard.getClipboard().setContents(selection);
    }

    protected void insertFigures(Vector<Figure> figures, int dx, int dy) {
        DrawingView view = this.getEditor().view();
        view.addAll(figures);
        view.addToSelectionAll(figures);
        StandardDrawingView.moveFigures(figures, dx, dy);
        view.checkDamage();
    }
}

