/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.standard.AbstractTool;
import java.awt.event.MouseEvent;

public class DragTracker
extends AbstractTool {
    protected Figure fAnchorFigure;
    private int fLastX;
    private int fLastY;
    private boolean fMoved = false;

    public DragTracker(DrawingEditor editor, Figure anchor) {
        super(editor);
        this.fAnchorFigure = anchor;
        this.editor().prepareUndoSnapshot();
    }

    @Override
    public void mouseDown(MouseEvent e, int x, int y) {
        super.mouseDown(e, x, y);
        this.fLastX = x;
        this.fLastY = y;
        if (e.isShiftDown()) {
            this.view().toggleSelection(this.fAnchorFigure);
            this.fAnchorFigure = null;
        } else if (!this.view().selection().contains(this.fAnchorFigure)) {
            this.view().clearSelection();
            this.view().addToSelection(this.fAnchorFigure);
        }
        this.altKeyBehavior(e);
    }

    @Override
    public void mouseDrag(MouseEvent e, int x, int y) {
        super.mouseDrag(e, x, y);
        boolean bl = this.fMoved = Math.abs(x - this.fAnchorX) > 4 || Math.abs(y - this.fAnchorY) > 4;
        if (this.fMoved) {
            this.drag(x - this.fLastX, y - this.fLastY);
        }
        this.fLastX = x;
        this.fLastY = y;
        this.altKeyBehavior(e);
    }

    protected void drag(int dx, int dy) {
        this.view().moveSelection(dx, dy);
    }

    @Override
    public void mouseUp(MouseEvent e, int x, int y) {
        if (this.fMoved) {
            this.editor().commitUndoSnapshot();
        }
        super.mouseUp(e, x, y);
    }

    public void altKeyBehavior(MouseEvent e) {
        if (this.fAnchorFigure != null) {
            if (e.isAltDown()) {
                this.fAnchorFigure.setAttribute("MoveWithChildren", true);
            } else {
                this.fAnchorFigure.setAttribute("MoveWithChildren", null);
            }
        }
    }
}

