/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.ConnectionFigure;
import CH.ifa.draw.framework.Connector;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.Locator;
import CH.ifa.draw.standard.LocatorHandle;
import CH.ifa.draw.util.Geom;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;

public class ConnectionHandle
extends LocatorHandle {
    private ConnectionFigure fConnection;
    private ConnectionFigure fPrototype;
    private Figure fTarget = null;

    public ConnectionHandle(Figure owner, Locator l, ConnectionFigure prototype) {
        super(owner, l);
        this.fPrototype = prototype;
    }

    @Override
    public void invokeStart(int x, int y, DrawingView view) {
        super.invokeStart(x, y, view);
        this.fConnection = this.createConnection();
        Point p = this.locate();
        this.fConnection.startPoint(p.x, p.y);
        this.fConnection.endPoint(p.x, p.y);
        view.drawing().add(this.fConnection);
    }

    protected ConnectionFigure getConnection() {
        return this.fConnection;
    }

    @Override
    public void invokeStep(MouseEvent e, int x, int y, int anchorX, int anchorY, DrawingView view) {
        Connector target;
        Point p = new Point(x, y);
        Figure f = null;
        List<Figure> figures = this.findAllConnectableFigures(x, y, view.drawing());
        for (Figure fig : figures) {
            if (fig == null || !fig.canConnect() || fig.includes(this.owner()) || !this.fConnection.canConnect(this.owner(), fig)) continue;
            f = fig;
            break;
        }
        if (f != this.fTarget) {
            if (this.fTarget != null) {
                this.fTarget.connectorVisibility(false);
            }
            this.fTarget = f;
            if (this.fTarget != null) {
                this.fTarget.connectorVisibility(true);
            }
        }
        if ((target = this.findConnectionTarget(p.x, p.y, view.drawing())) != null) {
            p = Geom.center(target.displayBox());
        } else if (e.isControlDown()) {
            p = this.snap(p.x, p.y);
        }
        this.fConnection.endPoint(p.x, p.y);
    }

    protected Point snap(int x, int y) {
        return new Point(x, y);
    }

    protected void handleConnect(Figure start, Figure end) {
    }

    @Override
    public void invokeEnd(int x, int y, int anchorX, int anchorY, DrawingView view) {
        Connector target = this.findConnectionTarget(x, y, view.drawing());
        if (target != null) {
            this.fConnection.connectStart(this.startConnector());
            this.fConnection.connectEnd(target);
            this.fConnection.updateConnection();
            this.handleConnect(this.startConnector().owner(), target.owner());
            target.owner().changed();
            view.clearSelection();
            view.addToSelection(target.owner());
        } else {
            view.drawing().remove(this.fConnection);
            this.noChangesMade();
        }
        this.fConnection = null;
        if (this.fTarget != null) {
            this.fTarget.connectorVisibility(false);
            this.fTarget = null;
        }
        super.invokeEnd(x, y, anchorX, anchorY, view);
    }

    @Override
    public void abort(DrawingView view) {
        view.drawing().remove(this.fConnection);
        this.noChangesMade();
        this.fConnection = null;
    }

    protected Connector startConnector() {
        Point p = this.locate();
        return this.owner().connectorAt(p.x, p.y);
    }

    protected ConnectionFigure createConnection() {
        return (ConnectionFigure)this.fPrototype.clone();
    }

    protected Connector findConnectionTarget(int x, int y, Drawing drawing) {
        List<Figure> possibleTargets = this.findAllConnectableFigures(x, y, drawing);
        for (Figure target : possibleTargets) {
            if (target == null || !target.canConnect() || target.includes(this.owner()) || !this.fConnection.canConnect(this.owner(), target)) continue;
            return this.findConnector(x, y, target);
        }
        return null;
    }

    protected Figure findConnectableFigure(int x, int y, Drawing drawing) {
        FigureEnumeration k = drawing.figuresReverse();
        while (k.hasMoreElements()) {
            Figure figure = k.nextFigure();
            if (figure.includes(this.fConnection) || !figure.canConnect() || !figure.containsPoint(x, y)) continue;
            return figure;
        }
        return null;
    }

    protected List<Figure> findAllConnectableFigures(int x, int y, Drawing drawing) {
        ArrayList<Figure> connectableFigures = new ArrayList<Figure>();
        FigureEnumeration k = drawing.figuresReverse();
        while (k.hasMoreElements()) {
            Figure figure = k.nextFigure();
            if (figure.includes(this.fConnection) || !figure.canConnect() || !figure.containsPoint(x, y)) continue;
            connectableFigures.add(figure);
        }
        return connectableFigures;
    }

    protected Connector findConnector(int x, int y, Figure f) {
        return f.connectorAt(x, y);
    }

    @Override
    public void draw(Graphics g) {
        Rectangle r = this.displayBox();
        g.setColor(Color.blue);
        g.drawOval(r.x, r.y, r.width, r.height);
    }
}

