/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.ChangeAttributeCommand;
import CH.ifa.draw.standard.ChooseAttributeCommand;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ChooseFontCommand
extends ChooseAttributeCommand {
    private JList fontList;
    private JList sizeList;
    private JCheckBox cbBold;
    private JCheckBox cbItalic;
    private JTextArea txtSample;
    private static final int[] sizes = new int[]{2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 30, 36, 48, 72};
    private SizeListModel sizeModel;

    public ChooseFontCommand(String displayName, String name, String attributeName, Class<?> type) {
        super(displayName, name, attributeName, type);
    }

    @Override
    protected void specializeDialog() {
        this.fontList = new JList(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()){

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                return new Dimension(150, 144);
            }
        };
        this.fontList.setSelectionMode(0);
        this.sizeModel = new SizeListModel(sizes);
        this.sizeList = new JList(this.sizeModel){

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                return new Dimension(25, 144);
            }
        };
        this.sizeList.setSelectionMode(0);
        this.cbBold = new JCheckBox("Bold");
        this.cbItalic = new JCheckBox("Italic");
        this.txtSample = new JTextArea(){

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                return new Dimension(385, 80);
            }
        };
        this.txtSample.setText("This is a sample text.");
        this.setFont(null);
        ListSelectionListener listListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ChooseFontCommand.this.txtSample.setFont(ChooseFontCommand.this.getCurrentFont());
            }
        };
        this.fontList.addListSelectionListener(listListener);
        this.sizeList.addListSelectionListener(listListener);
        ActionListener cbListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChooseFontCommand.this.txtSample.setFont(ChooseFontCommand.this.getCurrentFont());
            }
        };
        this.cbBold.addActionListener(cbListener);
        this.cbItalic.addActionListener(cbListener);
        JPanel fontChoosePanel = new JPanel();
        fontChoosePanel.setLayout(new BorderLayout());
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new BorderLayout());
        leftPanel.add((Component)new JScrollPane(this.fontList), "Center");
        leftPanel.add((Component)new JScrollPane(this.sizeList), "East");
        fontChoosePanel.add((Component)leftPanel, "Center");
        JPanel rightPanel = new JPanel();
        rightPanel.setLayout(new FlowLayout());
        rightPanel.add(this.cbBold);
        rightPanel.add(this.cbItalic);
        fontChoosePanel.add((Component)rightPanel, "East");
        fontChoosePanel.add((Component)new JScrollPane(this.txtSample), "South");
        this.dialog.getContentPane().add((Component)fontChoosePanel, "Center");
        this.dialog.setSize(200, 200);
        this.dialog.setResizable(true);
        this.dialog.pack();
    }

    private void setFont(Font font) {
        if (font == null) {
            font = this.txtSample.getFont();
        }
        this.fontList.setSelectedValue(font.getName(), true);
        this.fontList.ensureIndexIsVisible(this.fontList.getSelectedIndex());
        Integer sizeInt = font.getSize();
        this.sizeList.setSelectedValue(sizeInt, true);
        if (!sizeInt.equals(this.sizeList.getSelectedValue())) {
            this.sizeModel.addSize(sizeInt);
            this.sizeList.setSelectedValue(sizeInt, true);
        }
        this.sizeList.ensureIndexIsVisible(this.sizeList.getSelectedIndex());
        this.cbBold.setSelected(font.isBold());
        this.cbItalic.setSelected(font.isItalic());
        this.txtSample.setFont(font);
    }

    private Font getCurrentFont() {
        String fontFamily = (String)this.fontList.getSelectedValue();
        int fontSize = (Integer)this.sizeList.getSelectedValue();
        int fontType = 0;
        if (this.cbBold.isSelected()) {
            ++fontType;
        }
        if (this.cbItalic.isSelected()) {
            fontType += 2;
        }
        return new Font(fontFamily, fontType, fontSize);
    }

    @Override
    protected void updateFromFigure() {
        DrawingView view = this.getEditor().view();
        Font font = null;
        FigureEnumeration k = view.selectionElements();
        while (k.hasMoreElements() && font == null) {
            Figure f = k.nextFigure();
            Object fName = f.getAttribute("FontName");
            Object fStyle = f.getAttribute("FontStyle");
            Object fSize = f.getAttribute("FontSize");
            if (fName == null || fStyle == null || fSize == null) continue;
            font = new Font((String)fName, (int)((Integer)fStyle), (Integer)fSize);
        }
        this.setFont(font);
    }

    @Override
    protected void apply() {
        String fontFamily = (String)this.fontList.getSelectedValue();
        Integer fontSize = (Integer)this.sizeList.getSelectedValue();
        int fontType = 0;
        if (this.cbBold.isSelected()) {
            ++fontType;
        }
        if (this.cbItalic.isSelected()) {
            fontType += 2;
        }
        new ChangeAttributeCommand("", "FontName", fontFamily).execute();
        new ChangeAttributeCommand("", "FontSize", fontSize).execute();
        new ChangeAttributeCommand("", "FontStyle", fontType).execute();
    }

    private static class SizeListModel
    implements ListModel {
        private final List<Integer> sizeList;
        private final List<ListDataListener> listeners;

        public SizeListModel(int[] sizes) {
            this.sizeList = new ArrayList<Integer>(sizes.length * 2);
            for (int size : sizes) {
                this.sizeList.add(size);
            }
            Collections.sort(this.sizeList);
            this.listeners = new ArrayList<ListDataListener>();
        }

        public Object getElementAt(int index) {
            return this.sizeList.get(index);
        }

        @Override
        public int getSize() {
            return this.sizeList.size();
        }

        @Override
        public void addListDataListener(ListDataListener listener) {
            this.listeners.add(listener);
        }

        @Override
        public void removeListDataListener(ListDataListener listener) {
            this.listeners.remove(listener);
        }

        public void addSize(Integer size) {
            assert (size != null);
            assert (this.sizeList != null);
            int index = Collections.binarySearch(this.sizeList, size);
            if (index < 0) {
                int indexToInsert = -index - 1;
                this.sizeList.add(indexToInsert, size);
                ListDataEvent event = new ListDataEvent(this, 1, indexToInsert, indexToInsert);
                for (ListDataListener listener : this.listeners) {
                    listener.intervalAdded(event);
                }
            }
            assert (this.sizeList.contains(size));
        }
    }
}

