/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.UndoableCommand;
import java.awt.Color;

public class ChangeAttributeCommand
extends UndoableCommand {
    private String fAttribute;
    private Object fValue;

    public ChangeAttributeCommand(String name, String attributeName, Object value) {
        super(name);
        this.fAttribute = attributeName;
        this.fValue = value;
    }

    @Override
    public boolean executeUndoable() {
        DrawingView view = this.getEditor().view();
        FigureEnumeration k = view.selectionElements();
        while (k.hasMoreElements()) {
            Figure f = k.nextFigure();
            Object val = f.getAttribute(this.fAttribute);
            if (val instanceof Color && this.fValue instanceof Color) {
                Color c = (Color)this.fValue;
                int alphaValue = ((Color)val).getAlpha();
                c = new Color(c.getRed(), c.getGreen(), c.getBlue(), alphaValue);
                f.setAttribute(this.fAttribute, c);
                continue;
            }
            f.setAttribute(this.fAttribute, this.fValue);
        }
        view.checkDamage();
        return true;
    }

    @Override
    public boolean isExecutable() {
        if (!super.isExecutable()) {
            return false;
        }
        return this.getEditor().view().selectionCount() > 0;
    }
}

