/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.framework.AlphaChangeCommand;
import CH.ifa.draw.framework.DrawingViewDecoration;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.UndoableCommand;
import CH.ifa.draw.standard.ChangeAttributeCommand;
import CH.ifa.draw.standard.ChooseColorCommand;
import CH.ifa.draw.standard.ChooseFontCommand;
import CH.ifa.draw.standard.QueryAttributeCommand;
import CH.ifa.draw.standard.SelectionChangeListener;
import CH.ifa.draw.standard.SetLineWidthCommand;
import CH.ifa.draw.standard.SplineAttributeCommand;
import CH.ifa.draw.util.ColorMap;
import CH.ifa.draw.util.Command;
import CH.ifa.draw.util.ExtendedFont;
import CH.ifa.draw.util.GUIProperties;
import bibliothek.gui.dock.common.action.CAction;
import bibliothek.gui.dock.common.action.CButton;
import bibliothek.gui.dock.common.action.CDropDownButton;
import bibliothek.gui.dock.common.action.CMenu;
import bibliothek.gui.dock.common.action.CPanelPopup;
import bibliothek.gui.dock.common.action.CSeparator;
import bibliothek.gui.dock.common.action.panel.PanelPopupWindow;
import bibliothek.gui.dock.common.intern.action.CDecorateableAction;
import java.awt.Color;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AttributeMenuDecoration
implements SelectionChangeListener,
DrawingViewDecoration {
    private static final String IMAGES = "/CH/ifa/draw/images/";
    private static final List<String> basicFonts = new ArrayList<String>(){
        {
            this.add("Courier New");
            this.add("Andale Mono");
            this.add("Monaco");
            this.add("Profont");
            this.add("Monofur");
            this.add("Droid Sans Mono");
            this.add("DejaVu Sans Mono");
            this.add("Consolas");
            this.add("Inconsolata");
            this.add("Arial");
            this.add("Calibri");
            this.add("Lucida Sans");
        }
    };
    List<SelectionChangeListener> fSelectionChangeListeners = new LinkedList<SelectionChangeListener>();
    private LinkedList<CAction> menus;
    private int MAX_FONT_MENU_ENTRIES = 15;

    @Override
    public LinkedList<CAction> getDecorations() {
        if (this.menus == null) {
            this.menus = this.createMenus();
        }
        return this.menus;
    }

    private LinkedList createMenus() {
        LinkedList<Object> result = new LinkedList<Object>();
        result.add(this.createColorMenu("Fill Color", "FillColor", "fill_color"));
        result.add(this.createTransparencyMenu("Fill Color Transparency", "FillColor", "transparency_fill.png"));
        result.add(this.createColorMenu("Pen Color", "FrameColor", "pen_color"));
        result.add(this.createTransparencyMenu("Pen Color Transparency", "FrameColor", "transparency_pen.png"));
        result.add(this.createArrowMenu());
        result.add(this.createLineStyleMenu());
        result.add(this.createLineShapeMenu());
        result.add(this.createLineWidthMenu());
        result.add(CSeparator.SEPARATOR);
        result.add(this.createColorMenu("Text Color", "TextColor", "text_color"));
        result.add(this.createTransparencyMenu("Text Color Transparency", "TextColor", "transparency_text.png"));
        result.add(this.createFontSizeMenu());
        result.add(this.createFontStyleMenu());
        result.add(this.createTextAlignmentMenu());
        return result;
    }

    private CAction createTextAlignmentMenu() {
        CMenu menu = new CMenu();
        menu.setTooltip("Text Alignment");
        ChangeAttributeCommand command = new ChangeAttributeCommand("Left", "TextAlignment", 0);
        CommandExecutor button = new CommandExecutor(command);
        button.setTooltip("Align Left");
        ImageIcon icon = new ImageIcon(this.loadImage("/CH/ifa/draw/images/textalign_left.png"));
        button.setIcon(icon);
        menu.add((CAction)button);
        command = new ChangeAttributeCommand("Center", "TextAlignment", 1);
        button = new CommandExecutor(command);
        button.setTooltip("Align Center");
        icon = new ImageIcon(this.loadImage("/CH/ifa/draw/images/textalign_center.png"));
        button.setIcon(icon);
        menu.setIcon((Icon)icon);
        menu.add((CAction)button);
        command = new ChangeAttributeCommand("Right", "TextAlignment", 2);
        button = new CommandExecutor(command);
        button.setTooltip("Align Right");
        icon = new ImageIcon(this.loadImage("/CH/ifa/draw/images/textalign_right.png"));
        button.setIcon(icon);
        menu.add((CAction)button);
        this.setEnabledIfCommandExecutable((CDecorateableAction)menu, command);
        return menu;
    }

    private CAction createFontStyleMenu() {
        CMenu menu = new CMenu();
        ImageIcon icon = new ImageIcon(this.loadImage("/CH/ifa/draw/images/TEXT.gif"));
        menu.setIcon((Icon)icon);
        menu.setTooltip("Font Style");
        menu.add(this.createFontStyleButton("Plain", 0, "TEXT.gif"));
        menu.add(this.createFontStyleButton("Italic", 2, "italic.png"));
        menu.add(this.createFontStyleButton("Bold", 1, "bold.png"));
        menu.add(this.createFontStyleButton("Underlined", ExtendedFont.UNDERLINED, "underlined.png"));
        menu.addSeparator();
        menu.add(this.createFontMenu());
        this.setEnabledIfCommandExecutable((CDecorateableAction)menu, new ChangeAttributeCommand("", "FontStyle", 0));
        return menu;
    }

    private CAction createFontStyleButton(String title, Integer type, String iconpath) {
        ChangeAttributeCommand command = new ChangeAttributeCommand(title, "FontStyle", type);
        CommandExecutor button = new CommandExecutor(command);
        button.setTooltip("Font Style: " + title);
        ImageIcon icon = new ImageIcon(this.loadImage(IMAGES + iconpath));
        button.setIcon(icon);
        button.setShowTextOnButtons(false);
        return button;
    }

    private CAction createFontSizeMenu() {
        CPanelPopup popup = new CPanelPopup();
        popup.setCloseOnFocusLost(true);
        popup.setTooltip("Font Size");
        Integer[] sizes = new Integer[]{9, 10, 11, 12, 14, 18, 24, 36, 48, 72};
        JComboBox<Integer> comboBox = new JComboBox<Integer>(sizes);
        comboBox.setEditable(true);
        comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox box = (JComboBox)e.getSource();
                new ChangeAttributeCommand("", "FontSize", box.getSelectedItem()).execute();
            }
        });
        popup.setContent(comboBox);
        ImageIcon icon = new ImageIcon(this.loadImage("/CH/ifa/draw/images/fontsize.png"));
        popup.setIcon((Icon)icon);
        this.setEnabledIfCommandExecutable((CDecorateableAction)popup, new ChangeAttributeCommand("", "FontSize", 10));
        return popup;
    }

    private CAction createFontMenu() {
        CMenu menu = new CMenu();
        String[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        menu.setTooltip("Font Menu");
        menu.setText("Select Font");
        menu.setShowTextOnButtons(true);
        String defaultFontName = GUIProperties.defaultFontName();
        CommandExecutor button = new CommandExecutor(new ChangeAttributeCommand(defaultFontName + " (default)", "FontName", defaultFontName));
        menu.add((CAction)button);
        int k = 0;
        for (int i = 0; i < fonts.length && k < this.MAX_FONT_MENU_ENTRIES; ++i) {
            if (!basicFonts.contains(fonts[i]) || fonts[i] == defaultFontName) continue;
            button = new CommandExecutor(new ChangeAttributeCommand(fonts[i], "FontName", fonts[i]));
            menu.add((CAction)button);
            ++k;
        }
        button = new CommandExecutor(new ChooseFontCommand("Font Name", "other...", "FontName", String.class));
        menu.add((CAction)button);
        this.setEnabledIfCommandExecutable((CDecorateableAction)menu, new ChangeAttributeCommand(fonts[0], "FontName", fonts[0]));
        return menu;
    }

    private CAction createLineWidthMenu() {
        CPanelPopup popup = new CPanelPopup();
        JSlider slider = new JSlider(0, 1, 10, 10);
        slider.setMajorTickSpacing(1);
        slider.setPaintLabels(true);
        slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSlider s = (JSlider)e.getSource();
                if (!s.getValueIsAdjusting()) {
                    int value = s.getValue();
                    new SetLineWidthCommand("", value).execute();
                }
            }
        });
        popup.setCloseOnFocusLost(true);
        popup.setContent((JComponent)slider);
        popup.setTooltip("Line Width");
        ImageIcon icon = new ImageIcon(this.loadImage("/CH/ifa/draw/images/linewidth.png"));
        popup.setIcon((Icon)icon);
        this.setEnabledIfCommandExecutable((CDecorateableAction)popup, new SetLineWidthCommand("", 0));
        return popup;
    }

    private CAction createLineShapeMenu() {
        CMenu menu = new CMenu();
        menu.setTooltip("Line Shape");
        ImageIcon icon = new ImageIcon(this.loadImage("/CH/ifa/draw/images/lineshape_both.png"));
        menu.setIcon((Icon)icon);
        UndoableCommand command = new ChangeAttributeCommand("straight", "LineShape", 0);
        CommandExecutor button = new CommandExecutor(command);
        button.setTooltip("Straight");
        button.setText("Straight");
        icon = new ImageIcon(this.loadImage("/CH/ifa/draw/images/lineshape_straight.png"));
        button.setIcon(icon);
        menu.add((CAction)button);
        command = new SplineAttributeCommand("standard", "standard", 0);
        button = new CommandExecutor(command);
        button.setTooltip("Curved");
        button.setText("Curved");
        icon = new ImageIcon(this.loadImage("/CH/ifa/draw/images/lineshape_curved.png"));
        button.setIcon(icon);
        menu.add((CAction)button);
        this.setEnabledIfCommandExecutable((CDecorateableAction)menu, command);
        return menu;
    }

    private CAction createLineStyleMenu() {
        CMenu menu = new CMenu();
        menu.setTooltip("Line Style");
        menu.setIcon((Icon)this.createIcon("line_styles.gif"));
        Command command = new ChangeAttributeCommand("normal", "LineStyle", "");
        CommandExecutor button = new CommandExecutor(command);
        button.setIcon(this.createIcon("linestyle_normal.gif"));
        menu.add((CAction)button);
        command = new ChangeAttributeCommand("dotted", "LineStyle", "1 2");
        button = new CommandExecutor(command);
        button.setIcon(this.createIcon("linestyle_dotted.gif"));
        menu.add((CAction)button);
        command = new ChangeAttributeCommand("dashed", "LineStyle", "10");
        button = new CommandExecutor(command);
        button.setIcon(this.createIcon("linestyle_dashed.gif"));
        menu.add((CAction)button);
        command = new ChangeAttributeCommand("medium dashed", "LineStyle", "15 10");
        button = new CommandExecutor(command);
        button.setIcon(this.createIcon("linestyle_mediumdashed.gif"));
        menu.add((CAction)button);
        command = new ChangeAttributeCommand("long dashed", "LineStyle", "20");
        button = new CommandExecutor(command);
        button.setIcon(this.createIcon("linestyle_longdashed.gif"));
        menu.add((CAction)button);
        command = new ChangeAttributeCommand("dash-dotted", "LineStyle", "7 3 1 3");
        button = new CommandExecutor(command);
        button.setIcon(this.createIcon("linestyle_dashdotted.gif"));
        menu.add((CAction)button);
        this.setEnabledIfCommandExecutable((CDecorateableAction)menu, command);
        command = new QueryAttributeCommand("Line style (sequence of dash/gap lengths)", "other...", "LineStyle", String.class);
        button = new CommandExecutor(command);
        button.setIcon(this.createIcon("line_styles.gif"));
        menu.add((CAction)button);
        return menu;
    }

    private CAction createArrowMenu() {
        CDropDownButton menu = new CDropDownButton();
        menu.setIcon((Icon)this.createIcon("arrow_end.png"));
        menu.setTooltip("Arrows");
        ChangeAttributeCommand command = new ChangeAttributeCommand("none", "ArrowMode", 0);
        CommandExecutor button = new CommandExecutor(command);
        button.setIcon(this.createIcon("arrow_none.png"));
        menu.add((CAction)button);
        command = new ChangeAttributeCommand("at Start", "ArrowMode", 1);
        button = new CommandExecutor(command);
        button.setIcon(this.createIcon("arrow_start.png"));
        menu.add((CAction)button);
        command = new ChangeAttributeCommand("at End", "ArrowMode", 2);
        button = new CommandExecutor(command);
        button.setIcon(this.createIcon("arrow_end.png"));
        menu.add((CAction)button);
        command = new ChangeAttributeCommand("at Start/End", "ArrowMode", 3);
        button = new CommandExecutor(command);
        button.setIcon(this.createIcon("arrow_both.png"));
        menu.add((CAction)button);
        this.setEnabledIfCommandExecutable((CDecorateableAction)menu, command);
        return menu;
    }

    private CAction createTransparencyMenu(String title, final String attribute, String iconpath) {
        final TransparencySlider slider = new TransparencySlider();
        slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!slider.getValueIsAdjusting()) {
                    int value = slider.getValue();
                    new AlphaChangeCommand("", attribute, (int)Math.round((double)value * 2.55)).execute();
                    slider.adjustLabels(value);
                }
            }
        });
        TransparencySliderCPanelPopup popup = new TransparencySliderCPanelPopup(attribute, slider);
        popup.setCloseOnFocusLost(true);
        popup.setTooltip(title);
        popup.setMenuBehavior(CPanelPopup.MenuBehavior.SUBMENU);
        ImageIcon icon = new ImageIcon(this.loadImage(IMAGES + iconpath));
        popup.setIcon(icon);
        this.setEnabledIfCommandExecutable((CDecorateableAction)popup, new AlphaChangeCommand("", attribute, 0));
        return popup;
    }

    private CAction createColorMenu(String title, String attribute, String iconname) {
        CommandExecutor executor;
        CDropDownButton menu = new CDropDownButton();
        ImageIcon icon = new ImageIcon(this.loadImage(IMAGES + iconname + "_base.png"));
        menu.setIcon((Icon)icon);
        menu.setTooltip(title);
        for (int i = 0; i < ColorMap.size(); ++i) {
            Color color = ColorMap.color(i);
            executor = new CommandExecutor(new ChangeAttributeCommand(ColorMap.name(i), attribute, color));
            BufferedImage img = this.loadImage(IMAGES + iconname + "_color.png");
            if (img != null) {
                this.changeColor(img, color);
                icon = new ImageIcon(img);
                executor.setIcon(icon);
            }
            menu.add((CAction)executor);
        }
        executor = new CommandExecutor(new ChooseColorCommand(title, "other...", attribute, Color.class));
        menu.add((CAction)executor);
        this.setEnabledIfCommandExecutable((CDecorateableAction)menu, new ChangeAttributeCommand("", attribute, Color.BLUE));
        return menu;
    }

    @Override
    public void selectionStateChanged() {
        for (SelectionChangeListener listener : this.fSelectionChangeListeners) {
            listener.selectionStateChanged();
        }
    }

    private ImageIcon createIcon(String name) {
        BufferedImage img = this.loadImage(IMAGES + name);
        return new ImageIcon(img);
    }

    private BufferedImage loadImage(String path) {
        File file;
        BufferedImage result = null;
        URL url = AttributeMenuDecoration.class.getResource(path);
        if (url == null && (file = new File(path)) != null) {
            try {
                url = file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        if (url != null) {
            try {
                result = ImageIO.read(url);
                return result;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private void setEnabledIfCommandExecutable(final CDecorateableAction toggable, Command command) {
        final Command commandCopy = command;
        this.fSelectionChangeListeners.add(new SelectionChangeListener(){

            @Override
            public void selectionStateChanged() {
                if (!commandCopy.isExecutable()) {
                    toggable.setEnabled(false);
                } else {
                    toggable.setEnabled(true);
                }
            }
        });
    }

    private void changeColor(BufferedImage img, Color color) {
        Color standard = new Color(255, 0, 255);
        this.changeColor(img, standard, color);
    }

    private void changeColor(BufferedImage img, Color from, Color to) {
        int oldRGB = from.getRGB();
        int newRGB = to.getRGB();
        for (int x = 0; x < img.getWidth(); ++x) {
            for (int y = 0; y < img.getHeight(); ++y) {
                if (img.getRGB(x, y) != oldRGB) continue;
                img.setRGB(x, y, newRGB);
            }
        }
    }

    private class CommandExecutor
    extends CButton {
        final Command fCommand;

        public CommandExecutor(Command command) {
            this.fCommand = command;
            this.setText(command.name());
            this.setShowTextOnButtons(true);
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (CommandExecutor.this.fCommand.isExecutable()) {
                        CommandExecutor.this.fCommand.execute();
                    }
                }
            });
        }
    }

    private class TransparencySlider
    extends JSlider {
        public TransparencySlider() {
            super(0, 0, 100, 100);
            this.setMajorTickSpacing(20);
            this.setMinorTickSpacing(10);
            this.setPaintTicks(true);
            this.setPaintLabels(true);
        }

        public void adjustLabels(int value) {
            Hashtable<Integer, JComponent> labels = this.createStandardLabels(20);
            labels.put(value, new JLabel("" + value));
            double valueAsDouble = value;
            int toRemove = (int)Math.round(valueAsDouble / 20.0) * 20;
            labels.remove(toRemove);
            this.setLabelTable(labels);
        }
    }

    private class TransparencySliderCPanelPopup
    extends CPanelPopup {
        final TransparencySlider slider;
        final String attribute;

        public TransparencySliderCPanelPopup(String attribute, TransparencySlider slider) {
            this.attribute = attribute;
            this.slider = slider;
            this.setContent(slider);
        }

        public void openPopup(PanelPopupWindow window) {
            int value = 100;
            DrawPlugin plugin = DrawPlugin.getCurrent();
            if (plugin.isGuiPresent()) {
                Vector<Figure> v = plugin.getGui().view().selection();
                if (v.size() > 0) {
                    Figure f = v.get(0);
                    Color color = (Color)f.getAttribute(this.attribute);
                    double alpha = (double)color.getAlpha() / 2.55;
                    value = (int)alpha;
                }
            }
            ChangeListener[] listeners = this.slider.getChangeListeners();
            this.slider.removeChangeListener(listeners[0]);
            this.slider.setValue(value);
            this.slider.adjustLabels(value);
            this.slider.addChangeListener(listeners[0]);
            super.openPopup(window);
        }
    }
}

