/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.UndoableCommand;
import java.awt.Rectangle;

public class AlignCommand
extends UndoableCommand {
    public static final int LEFTS = 0;
    public static final int CENTERS = 1;
    public static final int RIGHTS = 2;
    public static final int TOPS = 3;
    public static final int MIDDLES = 4;
    public static final int BOTTOMS = 5;
    public static final int ANCHOR_LAST = 0;
    public static final int ANCHOR_FIRST = 1;
    public static final int ANCHOR_BIGGEST = 2;
    public static final int ANCHOR_SMALLEST = 3;
    public static final int ANCHOR_SELECTION = 4;
    private int fOp;
    private int fAnchor;

    public AlignCommand(String name, int op) {
        this(name, op, 1);
    }

    public AlignCommand(String name, int op, int anchor) {
        super(name);
        this.fOp = op;
        this.fAnchor = anchor;
    }

    @Override
    public boolean isExecutable() {
        if (!super.isExecutable()) {
            return false;
        }
        return this.getEditor().view().selectionCount() > 1;
    }

    @Override
    public boolean executeUndoable() {
        if (this.isExecutable()) {
            if (!super.isExecutable()) {
                return false;
            }
            DrawingView view = this.getEditor().view();
            Rectangle r = this.getAnchor(view, this.fAnchor, this.fOp);
            FigureEnumeration selection = view.selectionElements();
            while (selection.hasMoreElements()) {
                Figure f = selection.nextFigure();
                Rectangle rr = f.displayBox();
                switch (this.fOp) {
                    case 0: {
                        f.moveBy(r.x - rr.x, 0);
                        break;
                    }
                    case 1: {
                        f.moveBy(r.x + r.width / 2 - (rr.x + rr.width / 2), 0);
                        break;
                    }
                    case 2: {
                        f.moveBy(r.x + r.width - (rr.x + rr.width), 0);
                        break;
                    }
                    case 3: {
                        f.moveBy(0, r.y - rr.y);
                        break;
                    }
                    case 4: {
                        f.moveBy(0, r.y + r.height / 2 - (rr.y + rr.height / 2));
                        break;
                    }
                    case 5: {
                        f.moveBy(0, r.y + r.height - (rr.y + rr.height));
                    }
                }
            }
            view.checkDamage();
            return true;
        }
        return false;
    }

    private Rectangle getAnchor(DrawingView view, int anchor, int op) {
        Rectangle result = null;
        FigureEnumeration selection = view.selectionElements();
        if (selection.hasMoreElements()) {
            Rectangle first;
            Rectangle biggest = first = selection.nextFigure().displayBox();
            Rectangle smallest = first;
            Rectangle selectionBox = new Rectangle(first);
            Rectangle last = first;
            while (selection.hasMoreElements()) {
                Rectangle displayBox = selection.nextFigure().displayBox();
                if (op == 0 || op == 1 || op == 2) {
                    if (displayBox.width > biggest.width) {
                        biggest = displayBox;
                    }
                    if (displayBox.width < smallest.width) {
                        smallest = displayBox;
                    }
                } else if (op == 3 || op == 4 || op == 5) {
                    if (displayBox.height > biggest.height) {
                        biggest = displayBox;
                    }
                    if (displayBox.height < smallest.height) {
                        smallest = displayBox;
                    }
                }
                selectionBox.add(displayBox);
                if (selection.hasMoreElements()) continue;
                last = displayBox;
            }
            switch (anchor) {
                case 2: {
                    result = biggest;
                    break;
                }
                case 3: {
                    result = smallest;
                    break;
                }
                case 1: {
                    result = first;
                    break;
                }
                case 0: {
                    result = last;
                    break;
                }
                case 4: {
                    result = selectionBox;
                    break;
                }
                default: {
                    result = first;
                }
            }
        }
        return result;
    }
}

