/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.io;

import CH.ifa.draw.io.SimpleFileFilter;
import java.io.File;
import java.io.FileFilter;
import java.util.Collection;
import java.util.HashSet;

public class CombinationFileFilter
extends SimpleFileFilter
implements FileFilter {
    private final HashSet<SimpleFileFilter> filterList = new HashSet();
    private SimpleFileFilter preferredFileFilter;
    private String description;
    private boolean allowDirectory = true;
    private boolean allowHidden = false;

    public CombinationFileFilter(String description) {
        this.setDescription(description);
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    public boolean add(SimpleFileFilter ff) {
        boolean result = false;
        if (!this.contains(ff)) {
            if (this.filterList.isEmpty()) {
                this.preferredFileFilter = ff;
            }
            result = this.filterList.add(ff);
        }
        return result;
    }

    public boolean addAll(Collection<SimpleFileFilter> filters) {
        boolean result = false;
        for (SimpleFileFilter ff : filters) {
            result = this.add(ff) || result;
        }
        return result;
    }

    public boolean contains(SimpleFileFilter filter) {
        boolean result = false;
        for (SimpleFileFilter ff : this.filterList) {
            if (filter == null || !filter.equals(ff)) continue;
            result = true;
            break;
        }
        return result;
    }

    public void remove(SimpleFileFilter ff) {
        this.filterList.remove(ff);
    }

    public HashSet<SimpleFileFilter> getFileFilters() {
        return this.filterList;
    }

    @Override
    public String getExtension() {
        return this.getPreferedFileFilter().getExtension();
    }

    @Override
    public void allowHidden(boolean b) {
        this.allowHidden = b;
    }

    @Override
    public void allowDirectory(boolean b) {
        this.allowDirectory = b;
    }

    @Override
    public boolean isHiddenAllowed() {
        return this.allowHidden;
    }

    @Override
    public boolean isDirectoryAllowed() {
        return this.allowDirectory;
    }

    @Override
    public boolean accept(File f) {
        if (f == null) {
            return false;
        }
        if (!this.allowHidden && (f.isHidden() || f.getName().startsWith("."))) {
            return false;
        }
        if (f.isDirectory()) {
            return this.allowDirectory;
        }
        for (SimpleFileFilter filter : this.filterList) {
            if (!filter.accept(f)) continue;
            return true;
        }
        return false;
    }

    public SimpleFileFilter getPreferedFileFilter() {
        return this.preferredFileFilter;
    }

    public void setPreferedFileFilter(SimpleFileFilter filter) {
        this.preferredFileFilter = filter;
    }

    public boolean isEmpty() {
        return this.filterList.isEmpty();
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof CombinationFileFilter) {
            CombinationFileFilter other = (CombinationFileFilter)o;
            return this.getDescription().equals(other.getDescription()) && this.getFileFilters().equals(other.getFileFilters());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return CombinationFileFilter.class.hashCode() ^ this.getDescription().hashCode() ^ this.getFileFilters().hashCode();
    }
}

