/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.LayoutManager;

public class ToolPanelLayout
implements LayoutManager {
    private int _maxWidth;
    private int _minWidth;
    private int _columns;

    public ToolPanelLayout(int minWidth, int maxWidth) {
        assert (minWidth > 0) : "Minimum width may not be smaller 0.";
        this._maxWidth = maxWidth;
        this._minWidth = minWidth;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container parent) {
        int height;
        int width;
        Object object = parent.getTreeLock();
        synchronized (object) {
            Dimension d = this.calculatePreferredWidth(parent);
            width = d != null ? d.width : this._minWidth * 5;
            height = this.calculatePreferredHeight(width, parent);
        }
        return new Dimension(width, height);
    }

    private int calculatePreferredHeight(int containerWidth, Container parent) {
        int result = 0;
        Insets insets = parent.getInsets();
        int componentsPerRow = (containerWidth - (insets.left + insets.right)) / this._minWidth;
        int count = parent.getComponentCount();
        if (count > 0 && componentsPerRow > 0) {
            int rows = (int)Math.ceil((double)count / (double)componentsPerRow);
            int heightPerComponent = parent.getComponent((int)0).getPreferredSize().height;
            result = rows * heightPerComponent + parent.getInsets().top;
        }
        return result;
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return new Dimension(this._minWidth * 3, 50);
    }

    private Dimension calculatePreferredWidth(Container parent) {
        Dimension result;
        Container container = parent;
        do {
            result = container.getSize();
            container = container.getParent();
        } while ((result == null || result.width <= 0) && container != null);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Insets insets = parent.getInsets();
            int parentWidth = this.calculatePreferredWidth((Container)parent).width - (insets.left + insets.right);
            int componentsPerRow = parentWidth / this._minWidth;
            if (componentsPerRow == 0) {
                componentsPerRow = 1;
            }
            int width = Math.min(parentWidth / componentsPerRow, this._maxWidth);
            int lastWidth = width + parentWidth % width;
            int count = parent.getComponentCount();
            int x = 0;
            int y = insets.top;
            int column = 0;
            if (count > 0) {
                Component c = parent.getComponent(0);
                int height = c.getPreferredSize().height;
                for (int i = 0; i < count; ++i) {
                    c = parent.getComponent(i);
                    if (!c.isVisible()) continue;
                    c.setSize(width, height);
                    c.setLocation(x, y);
                    x += width;
                    if (++column < componentsPerRow) continue;
                    c.setSize(lastWidth, height);
                    column = 0;
                    y += height;
                    x = 0;
                }
            }
            if (this._columns != componentsPerRow) {
                this._columns = componentsPerRow;
                EventQueue.invokeLater(parent::revalidate);
            }
        }
    }

    public void setMaximumComponentWidth(int width) {
        this._maxWidth = width;
    }

    public void setMinimumComponentWidth(int width) {
        this._minWidth = width;
    }
}

