/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.framework;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureSelection;
import java.util.Vector;

public class SnapshotHistory {
    private final Vector<FigureSelection> _history;
    private final int _maxSize;
    private final Drawing _drawing;
    private FigureSelection _preparedSnapshot;

    public SnapshotHistory(Drawing drawing, int maxSize) {
        this._maxSize = maxSize;
        this._drawing = drawing;
        this._preparedSnapshot = null;
        this._history = new Vector(maxSize);
    }

    public void takeSnapshot() {
        this.prepareSnapshot();
        this.commitSnapshot();
    }

    public void prepareSnapshot() {
        this._preparedSnapshot = new FigureSelection(this._drawing.figures());
    }

    public void commitSnapshot() {
        if (this._preparedSnapshot != null) {
            this._history.addElement(this._preparedSnapshot);
            this._preparedSnapshot = null;
            if (this._history.size() > this._maxSize) {
                this._history.removeElementAt(0);
            }
        }
    }

    public void restoreSnapshot() {
        if (!this._history.isEmpty()) {
            FigureSelection snapshot = this._history.lastElement();
            this._history.removeElementAt(this._history.size() - 1);
            this._drawing.removeAll();
            Vector<Figure> restoreFigures = snapshot.getData("CH.ifa.draw.Figures");
            this._drawing.addAll(restoreFigures);
            this._drawing.checkDamage();
        }
    }

    public void clear() {
        this._history.removeAllElements();
    }

    public boolean isEmpty() {
        return this._history.isEmpty();
    }
}

