/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.framework;

import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.UndoableCommand;
import CH.ifa.draw.standard.NullDrawingEditor;
import java.awt.Color;

public class AlphaChangeCommand
extends UndoableCommand {
    private final String _attribute;
    private final int _value;

    public AlphaChangeCommand(String name, String attributeName, int value) {
        super(name);
        this._attribute = attributeName;
        this._value = value;
    }

    @Override
    protected boolean executeUndoable() {
        DrawingView view = this.getEditor().view();
        FigureEnumeration k = view.selectionElements();
        while (k.hasMoreElements()) {
            Figure f = k.nextFigure();
            Object val = f.getAttribute(this._attribute);
            if (!(val instanceof Color)) continue;
            Color c = (Color)val;
            c = new Color(c.getRed(), c.getGreen(), c.getBlue(), this._value);
            f.setAttribute(this._attribute, c);
        }
        view.checkDamage();
        return true;
    }

    @Override
    public boolean isExecutable() {
        if (this.getEditor() == NullDrawingEditor.INSTANCE) {
            return false;
        }
        return this.getEditor().view().selectionCount() > 0;
    }
}

