/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.AttributeFigure;
import CH.ifa.draw.figures.FontSizeHandle;
import CH.ifa.draw.framework.ChildFigure;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureChangeEvent;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.Handle;
import CH.ifa.draw.framework.ParentFigure;
import CH.ifa.draw.standard.FigureEnumerator;
import CH.ifa.draw.standard.MergedFigureEnumerator;
import CH.ifa.draw.standard.NullHandle;
import CH.ifa.draw.standard.OffsetLocator;
import CH.ifa.draw.standard.RelativeLocator;
import CH.ifa.draw.standard.StandardDrawingEditor;
import CH.ifa.draw.standard.TextHolder;
import CH.ifa.draw.util.ColorMap;
import CH.ifa.draw.util.ExtendedFont;
import CH.ifa.draw.util.Fontkit;
import CH.ifa.draw.util.GUIProperties;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Logger;

public class TextFigure
extends AttributeFigure
implements ChildFigure,
TextHolder {
    public static Logger logger;
    private static String fgCurrentFontName;
    private static int fgCurrentFontSize;
    private static int fgCurrentFontStyle;
    private static final long serialVersionUID = 4599820785949456124L;
    public static final String ALIGN_ATTR = "TextAlignment";
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    private int fOriginX = 0;
    private int fOriginY = 0;
    private transient boolean fSizeIsDirty = true;
    private transient int fWidth;
    private transient int fHeight;
    private transient Rectangle[] boxes;
    private String fText;
    private String[] fLines;
    private transient Font fFont = null;
    private String fCurrentFontName = fgCurrentFontName;
    private int fCurrentFontSize;
    private int fCurrentFontStyle = fgCurrentFontStyle;
    private boolean fIsReadOnly;
    private boolean fCanBeConnected = true;
    private ParentFigure fParent = null;
    private OffsetLocator fLocator = null;
    private int textFigureSerializedDataVersion = 1;

    public TextFigure() {
        this("");
    }

    public TextFigure(boolean canBeConnected) {
        this("");
        this.fCanBeConnected = canBeConnected;
    }

    public TextFigure(String text) {
        this.fCurrentFontSize = fgCurrentFontSize;
        this.setAttribute("FillColor", ColorMap.color("None"));
        this.setAttribute("FrameColor", ColorMap.color("None"));
        this.internalSetText(text);
        this.fSizeIsDirty = true;
    }

    protected static FontMetrics getDefaultFontMetrics(Font font) {
        BufferedImage bi = new BufferedImage(1, 1, 3);
        Graphics g = bi.getGraphics();
        FontMetrics fm = g.getFontMetrics(font);
        g.dispose();
        bi = null;
        return fm;
    }

    public TextFigure(String text, boolean isReadOnly) {
        this(text);
        this.setReadOnly(isReadOnly);
    }

    @Override
    public void moveBy(int x, int y) {
        this.willChange();
        this.basicMoveBy(x, y);
        if (this.fLocator != null) {
            this.fLocator.moveBy(x, y);
        }
        this.changed();
    }

    @Override
    protected void basicMoveBy(int x, int y) {
        this.fOriginX += x;
        this.fOriginY += y;
    }

    @Override
    public void basicDisplayBox(Point newOrigin, Point newCorner) {
        this.fOriginX = newOrigin.x;
        this.fOriginY = newOrigin.y;
    }

    public Point getOrigin() {
        return new Point(this.fOriginX, this.fOriginY);
    }

    @Override
    public Rectangle displayBox() {
        this.textExtent();
        return new Rectangle(this.fOriginX, this.fOriginY, this.fWidth, this.fHeight);
    }

    @Override
    public Rectangle textDisplayBox() {
        return this.displayBox();
    }

    protected String getLine(int lineIndex) {
        return this.fLines[lineIndex];
    }

    protected int getLineAlignment(int lineIndex) {
        return this.getAlignment();
    }

    protected Font getLineFont(int lineIndex) {
        return this.getFont();
    }

    public static FontMetrics getMetrics(Font font, Graphics g) {
        if (g != null) {
            FontMetrics fm = g.getFontMetrics(font);
            return fm;
        }
        logger.trace((Object)"Using default font metrics because no Graphics object is at hand. ");
        return TextFigure.getDefaultFontMetrics(font);
    }

    public Rectangle getLineBox(Graphics g, int i) {
        if (this.fSizeIsDirty) {
            this.getLineBoxes(g);
        }
        return this.boxes[i];
    }

    protected Dimension getLineDimension(int i, Graphics g) {
        FontMetrics metrics = TextFigure.getMetrics(this.getLineFont(i), g);
        return new Dimension(metrics.stringWidth(this.getLine(i)), metrics.getHeight());
    }

    protected Rectangle[] getLineBoxes(Graphics g) {
        if (this.fSizeIsDirty) {
            int i;
            this.boxes = new Rectangle[this.fLines.length];
            int oldWidth = this.fWidth;
            this.fWidth = 0;
            this.fHeight = 0;
            for (i = 0; i < this.fLines.length; ++i) {
                Dimension dim = this.getLineDimension(i, g);
                this.boxes[i] = new Rectangle(0, this.fHeight, dim.width, dim.height);
                this.fWidth = Math.max(this.fWidth, dim.width);
                this.fHeight += dim.height;
            }
            for (i = 0; i < this.fLines.length; ++i) {
                int alignment = this.getLineAlignment(i);
                if (alignment == 0) continue;
                int dx = this.fWidth - this.boxes[i].width;
                if (alignment == 1) {
                    dx /= 2;
                }
                this.boxes[i].translate(dx, 0);
            }
            if (oldWidth != 0) {
                switch (this.getAlignment()) {
                    case 2: {
                        this.fOriginX = this.fOriginX + oldWidth - this.fWidth;
                        if (this.fLocator == null) break;
                        this.fLocator.moveBy((oldWidth - this.fWidth) / 2, 0);
                        break;
                    }
                    case 1: {
                        this.fOriginX += (oldWidth - this.fWidth) / 2;
                        break;
                    }
                    default: {
                        if (this.fLocator == null) break;
                        this.fLocator.moveBy(-(oldWidth - this.fWidth) / 2, 0);
                    }
                }
            }
            this.fSizeIsDirty = false;
        }
        return this.boxes;
    }

    @Override
    public boolean containsPoint(int x, int y) {
        if (super.containsPoint(x, y)) {
            if (!ColorMap.isTransparent(this.getFrameColor())) {
                return true;
            }
            x -= this.fOriginX;
            y -= this.fOriginY;
            Rectangle[] boxes = this.getLineBoxes(null);
            for (int i = 0; i < boxes.length; ++i) {
                if (!boxes[i].contains(x, y)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean readOnly() {
        return this.fIsReadOnly;
    }

    @Override
    public void setReadOnly(boolean isReadOnly) {
        this.fIsReadOnly = isReadOnly;
    }

    @Override
    public Font getFont() {
        if (this.fFont == null) {
            this.fFont = Fontkit.getFont(this.fCurrentFontName, this.fCurrentFontStyle, this.fCurrentFontSize);
        }
        return this.fFont;
    }

    public void setFont(Font newFont) {
        this.willChange();
        this.fFont = newFont;
        this.fCurrentFontName = this.fFont.getName();
        this.fCurrentFontStyle = this.fFont.getStyle();
        this.fCurrentFontSize = this.fFont.getSize();
        this.markDirty();
        this.changed();
    }

    @Override
    public void changed() {
        super.changed();
        this.updateLocation();
    }

    public int getAlignment() {
        return (Integer)this.getAttribute(ALIGN_ATTR);
    }

    public void setAlignment(int alignment) {
        this.setAttribute(ALIGN_ATTR, alignment);
    }

    @Override
    public Object getAttribute(String name) {
        if (name.equals("FontSize")) {
            return this.fCurrentFontSize;
        }
        if (name.equals("FontStyle")) {
            return this.fCurrentFontStyle;
        }
        if (name.equals("FontName")) {
            return this.fCurrentFontName;
        }
        return super.getAttribute(name);
    }

    @Override
    public void setAttribute(String name, Object value) {
        if (name.equals("FontSize") || name.equals("FontStyle") || name.equals("FontName")) {
            this.willChange();
            if (name.equals("FontSize")) {
                this.fCurrentFontSize = (Integer)value;
            } else if (name.equals("FontStyle")) {
                int s = (Integer)value;
                this.fCurrentFontStyle = s == 0 ? 0 : (this.fCurrentFontStyle ^= s);
            } else if (name.equals("FontName")) {
                this.fCurrentFontName = (String)value;
            }
            this.fFont = null;
            this.markDirty();
            this.changed();
            this.markDirty();
            this.changed();
        } else {
            super.setAttribute(name, value);
            if (name.equals(ALIGN_ATTR)) {
                this.willChange();
                this.markDirty();
                this.changed();
            }
        }
    }

    @Override
    public String getText() {
        return this.fText;
    }

    public String[] getLines() {
        return this.fLines;
    }

    @Override
    public void setText(String newText) {
        if (!newText.equals(this.fText)) {
            this.willChange();
            this.basicSetText(newText);
            this.changed();
        }
    }

    protected void basicSetText(String newText) {
        this.internalSetText(newText);
        this.markDirty();
    }

    protected void internalSetText(String newText) {
        this.fText = newText;
        this.fLines = TextFigure.splitTextLines(newText);
    }

    protected void internalSetTextHiddenParts(String fullText, String displayText) {
        this.fText = fullText;
        this.fLines = TextFigure.splitTextLines(displayText);
    }

    private static String[] splitTextLines(String text) {
        Vector<String> vector = new Vector<String>();
        StringTokenizer lines = new StringTokenizer(text, "\n", true);
        boolean lastLineTerminated = true;
        while (lines.hasMoreElements()) {
            String line = lines.nextToken();
            if ("\n".equals(line)) {
                line = "";
                lastLineTerminated = true;
            } else if (lines.hasMoreElements()) {
                lines.nextToken();
                lastLineTerminated = true;
            } else {
                lastLineTerminated = false;
            }
            vector.addElement(line);
        }
        if (lastLineTerminated) {
            vector.addElement("");
        }
        Object[] arr = new String[vector.size()];
        vector.copyInto(arr);
        return arr;
    }

    @Override
    public boolean acceptsTyping() {
        return !this.fIsReadOnly;
    }

    @Override
    public void internalDraw(Graphics g) {
        Color textColor;
        super.internalDraw(g);
        Color fillColor = this.getFillColor();
        this.getLineBoxes(g);
        g.translate(this.fOriginX, this.fOriginY);
        if (ColorMap.isTransparent(this.getFrameColor()) && !ColorMap.isTransparent(fillColor)) {
            g.setColor(fillColor);
            for (int i = 0; i < this.fLines.length; ++i) {
                g.fillRect(this.boxes[i].x, this.boxes[i].y, this.boxes[i].width, this.boxes[i].height);
            }
        }
        if (!ColorMap.isTransparent(textColor = (Color)this.getAttribute("TextColor"))) {
            g.setColor(textColor);
            for (int i = 0; i < this.fLines.length; ++i) {
                this.drawLine(g, i);
            }
        }
        g.translate(-this.fOriginX, -this.fOriginY);
    }

    protected void drawLine(Graphics g, int i) {
        Font font = this.getLineFont(i);
        g.setFont(font);
        int x = this.boxes[i].x;
        int y = this.boxes[i].y;
        String s = this.getLine(i);
        g.drawString(s, x, y + TextFigure.getMetrics(font, g).getAscent());
        if (font instanceof ExtendedFont && ((ExtendedFont)font).isUnderlined()) {
            FontMetrics fm = g.getFontMetrics();
            LineMetrics lm = fm.getLineMetrics(s, g);
            Graphics2D g2 = (Graphics2D)g;
            Rectangle2D.Float shape = new Rectangle2D.Float(x, y + (int)lm.getUnderlineOffset() + TextFigure.getMetrics(font, g).getAscent(), fm.stringWidth(s), Math.max(1, (int)lm.getUnderlineThickness()));
            g2.fill(shape);
        }
    }

    @Override
    public void drawBackground(Graphics g) {
        if (!ColorMap.isTransparent(this.getFrameColor())) {
            Rectangle r = this.displayBox();
            Graphics2D g2 = (Graphics2D)g;
            Rectangle2D.Float s = new Rectangle2D.Float(r.x, r.y, r.width, r.height);
            g2.fill(s);
        }
    }

    @Override
    public void drawFrame(Graphics g) {
        Rectangle r = this.displayBox();
        Graphics2D g2 = (Graphics2D)g;
        Rectangle2D.Float s = new Rectangle2D.Float(r.x, r.y, r.width, r.height);
        g2.draw(s);
    }

    private Dimension textExtent() {
        this.getLineBoxes(null);
        return new Dimension(this.fWidth, this.fHeight);
    }

    protected void markDirty() {
        this.fSizeIsDirty = true;
    }

    @Override
    public Dimension overlayRowsAndColumns() {
        int columns = 20;
        String[] lines = this.getLines();
        for (int i = 0; i < lines.length; ++i) {
            columns = Math.max(columns, lines[i].length() + 3);
        }
        int rows = Math.max(1, lines.length);
        return new Dimension(columns, rows);
    }

    @Override
    public Vector<Handle> handles() {
        Vector<Handle> handles = new Vector<Handle>();
        handles.addElement(new NullHandle(this, RelativeLocator.northWest()));
        handles.addElement(new NullHandle(this, RelativeLocator.northEast()));
        handles.addElement(new NullHandle(this, RelativeLocator.southEast()));
        handles.addElement(new FontSizeHandle(this, RelativeLocator.southWest()));
        return handles;
    }

    @Override
    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeInt(this.fOriginX);
        dw.writeInt(this.fOriginY);
        dw.writeString(this.fText);
        dw.writeString(this.fCurrentFontName);
        dw.writeInt(this.fCurrentFontStyle);
        dw.writeInt(this.fCurrentFontSize);
        dw.writeBoolean(this.fIsReadOnly);
        dw.writeStorable(this.fParent);
        dw.writeStorable(this.fLocator);
    }

    @Override
    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.fOriginX = dr.readInt();
        this.fOriginY = dr.readInt();
        String text = dr.readString();
        this.setText(text);
        this.fCurrentFontName = dr.readString();
        this.fCurrentFontStyle = dr.readInt();
        this.fCurrentFontSize = dr.readInt();
        if (dr.getVersion() < 8 && "Helvetica".equals(this.fCurrentFontName)) {
            this.fCurrentFontName = "SansSerif";
        }
        this.fFont = null;
        this.fIsReadOnly = dr.readBoolean();
        this.fParent = (ParentFigure)dr.readStorable();
        this.fLocator = (OffsetLocator)dr.readStorable();
        if (this.fParent != null) {
            this.fParent.addChild(this);
        } else {
            this.fCanBeConnected = false;
        }
        if (GUIProperties.noGraphics()) {
            this.fSizeIsDirty = false;
        } else {
            this.updateLocation();
        }
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        if (this.fParent != null) {
            this.fParent.addChild(this);
        }
        this.markDirty();
    }

    @Override
    public boolean canBeParent(ParentFigure figure) {
        if (!this.fCanBeConnected) {
            return figure == null;
        }
        while (figure != null) {
            if (figure == this) {
                return false;
            }
            if (!(figure instanceof ChildFigure)) break;
            figure = ((ChildFigure)((Object)figure)).parent();
        }
        return true;
    }

    @Override
    public boolean setParent(ParentFigure figure) {
        if (!this.canBeParent(figure)) {
            return false;
        }
        if (this.fParent != null) {
            this.fParent.removeChild(this);
        }
        this.fParent = figure;
        if (this.fParent == null) {
            this.fLocator = null;
        } else {
            this.fParent.addChild(this);
            if (this.fLocator != null) {
                this.fLocator.setBase(this.fParent.connectedTextLocator(this));
            } else {
                this.fLocator = new OffsetLocator(this.fParent.connectedTextLocator(this));
            }
            this.updateLocation();
        }
        return true;
    }

    @Override
    public ParentFigure parent() {
        return this.fParent;
    }

    @Override
    public void updateLocation() {
        if (this.fLocator != null) {
            Point p = this.fLocator.locate(this.fParent);
            p.x -= this.size().width / 2 + this.fOriginX;
            p.y -= this.size().height / 2 + this.fOriginY;
            if (p.x != 0 || p.y != 0) {
                this.willChange();
                this.basicMoveBy(p.x, p.y);
                this.changed();
            }
        }
    }

    @Override
    public void release() {
        super.release();
        if (this.fParent != null) {
            this.fParent.removeChild(this);
        }
    }

    public static Font createCurrentFont() {
        return Fontkit.getFont(fgCurrentFontName, fgCurrentFontStyle, fgCurrentFontSize);
    }

    public static void setCurrentFontName(String name) {
        fgCurrentFontName = name;
    }

    public static void setCurrentFontSize(int size) {
        fgCurrentFontSize = size;
    }

    public static void setCurrentFontStyle(int style) {
        fgCurrentFontStyle = style;
    }

    @Override
    public void figureChanged(FigureChangeEvent e) {
        this.updateLocation();
    }

    @Override
    public void figureHandlesChanged(FigureChangeEvent e) {
    }

    @Override
    public void figureRemoved(FigureChangeEvent e) {
        if (this.listener() != null) {
            this.listener().figureRequestRemove(new FigureChangeEvent(this));
        }
    }

    @Override
    public void figureRequestRemove(FigureChangeEvent e) {
    }

    @Override
    public void figureInvalidated(FigureChangeEvent e) {
    }

    @Override
    public void figureRequestUpdate(FigureChangeEvent e) {
    }

    @Override
    public FigureEnumeration getFiguresWithDependencies() {
        FigureEnumeration superDep = super.getFiguresWithDependencies();
        Vector<Figure> myDep = new Vector<Figure>(1);
        myDep.addElement(this.parent());
        return new MergedFigureEnumerator(superDep, new FigureEnumerator(myDep));
    }

    @Override
    public boolean inspect(DrawingView view, boolean alternate) {
        if (!alternate) {
            return super.inspect(view, false);
        }
        if (this.acceptsTyping()) {
            ((StandardDrawingEditor)view.editor()).doTextEdit(this);
            return true;
        }
        return false;
    }

    static {
        String defaultFontName;
        logger = Logger.getLogger(TextFigure.class);
        fgCurrentFontName = "SansSerif";
        fgCurrentFontSize = 12;
        fgCurrentFontStyle = 0;
        int defaultFontSize = GUIProperties.defaultFontSize();
        if (defaultFontSize != -1) {
            fgCurrentFontSize = defaultFontSize;
            logger.debug((Object)("Setting default font size to " + fgCurrentFontSize + " pt."));
        }
        if ((defaultFontName = GUIProperties.defaultFontName()) != "none") {
            fgCurrentFontName = defaultFontName;
            logger.debug((Object)("Setting default font to " + fgCurrentFontName + "."));
        }
    }
}

