/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.standard.CreationTool;
import CH.ifa.draw.standard.TextHolder;
import CH.ifa.draw.util.FloatingTextField;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.net.URI;
import org.apache.log4j.Logger;

public class TargetTool
extends CreationTool {
    public static Logger logger = Logger.getLogger(TargetTool.class);
    private static final String TARGET_LOCATION = "targetLocation";
    protected FloatingTextField fTextField;
    private Figure fTypingTarget;

    public TargetTool(DrawingEditor editor) {
        super(editor, new TextFigure(false));
    }

    @Override
    public void mouseDown(MouseEvent e, int x, int y) {
        TextFigure textFigure = null;
        if (this.fTypingTarget != null) {
            this.endEdit();
            this.editor().toolDone();
        } else {
            this.fTypingTarget = this.drawing().findFigureInside(x, y);
            if (this.fTypingTarget != null) {
                String targetLocation = (String)this.fTypingTarget.getAttribute(TARGET_LOCATION);
                super.mouseDown(e, x, y);
                textFigure = (TextFigure)this.createdFigure();
                if (targetLocation != null) {
                    textFigure.setText(targetLocation);
                } else {
                    textFigure.setText("");
                }
                this.beginEdit(textFigure);
            }
        }
    }

    @Override
    public void mouseDrag(MouseEvent e, int x, int y) {
    }

    @Override
    public void mouseUp(MouseEvent e, int x, int y) {
    }

    @Override
    public void deactivate() {
        super.deactivate();
        this.endEdit();
    }

    @Override
    public void activate() {
        super.activate();
    }

    protected boolean isTypingActive() {
        return this.fTypingTarget != null;
    }

    public void beginEdit(TextFigure figure) {
        if (this.fTextField == null) {
            this.fTextField = new FloatingTextField();
            this.fTextField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.isControlDown() && keyEvent.getKeyCode() == 10) {
                        TargetTool.this.deactivate();
                        TargetTool.this.editor().toolDone();
                    }
                }
            });
        }
        this.fTextField.setText(figure.getText());
        this.fTextField.createOverlay((Container)((Object)this.view()), this.fieldBounds(figure), figure.getFont());
        this.view().remove(figure);
    }

    public void setCaretPosition(int line, int col) {
        this.fTextField.setCaretPosition(line, col);
    }

    public void endEdit() {
        if (this.fTypingTarget != null) {
            String newText = this.fTextField.getText();
            String oldText = (String)this.fTypingTarget.getAttribute(TARGET_LOCATION);
            if (newText.equals("")) {
                this.fTypingTarget.setAttribute(TARGET_LOCATION, null);
            } else {
                try {
                    URI uri;
                    if (!newText.startsWith("sim") && (uri = new URI(newText)).isAbsolute()) {
                        uri.toURL();
                    }
                    this.fTypingTarget.setAttribute(TARGET_LOCATION, newText);
                }
                catch (Exception e3) {
                    logger.error((Object)("Renaming link failed for : " + newText));
                    logger.debug((Object)e3);
                }
            }
            this.fTypingTarget = null;
            this.fTextField.endOverlay();
            this.view().checkDamage();
            if (oldText != null) {
                if (!oldText.equals(newText)) {
                    this.changesMade();
                    this.intermediateUndoSnapshot();
                } else {
                    this.noChangesMade();
                }
            } else if (!newText.equals("")) {
                this.changesMade();
                this.intermediateUndoSnapshot();
            } else {
                this.noChangesMade();
            }
        }
    }

    private Rectangle fieldBounds(TextHolder figure) {
        Rectangle box = figure.textDisplayBox();
        return box;
    }
}

