/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.framework.ChildFigure;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.FigureFilter;
import CH.ifa.draw.util.Command;
import java.util.HashSet;
import java.util.Vector;

public class SelectCommand
extends Command {
    public static final int SELECT = 0;
    public static final int ADD = 1;
    public static final int REMOVE = 2;
    public static final int RESTRICT = 3;
    public static final int INVERT = 4;
    protected DrawingEditor fEditor;
    protected FigureFilter fFilter;
    protected int selectMode;

    public SelectCommand(String name) {
        this(name, Figure.class, null, 0);
    }

    public SelectCommand(String name, Class<?> figureClass) {
        this(name, figureClass, 0);
    }

    public SelectCommand(String name, Class<?> figureClass, int selectMode) {
        this(name, figureClass, null, selectMode);
    }

    public SelectCommand(String name, Class<?> figureClass, Class<?> parentClass) {
        this(name, figureClass, parentClass, 0);
    }

    public SelectCommand(String name, final Class<?> figureClass, final Class<?> parentClass, int selectMode) {
        this(name, new FigureFilter(){

            @Override
            public boolean isUsed(Figure fig) {
                return figureClass.isInstance(fig) && (parentClass == null || parentClass.isInstance(((ChildFigure)fig).parent()));
            }
        }, selectMode);
    }

    public SelectCommand(String name, FigureFilter filter) {
        this(name, filter, 0);
    }

    public SelectCommand(String name, FigureFilter filter, int selectMode) {
        super(name);
        this.fFilter = filter;
        this.selectMode = selectMode;
    }

    @Override
    public void execute() {
        DrawingView view = DrawPlugin.getCurrent().getDrawingEditor().view();
        Drawing drawing = view.drawing();
        FigureEnumeration figenumeration = drawing.figures();
        Vector<Figure> concerned = new Vector<Figure>();
        FigureEnumeration selected = view.selectionElements();
        HashSet<Figure> selectedSet = new HashSet<Figure>();
        while (selected.hasMoreElements()) {
            selectedSet.add(selected.nextFigure());
        }
        while (figenumeration.hasMoreElements()) {
            Figure fig = figenumeration.nextFigure();
            if (this.selectMode != 4) {
                if (this.fFilter.isUsed(fig)) {
                    if (this.selectMode == 3) continue;
                    concerned.addElement(fig);
                    continue;
                }
                if (this.selectMode != 3) continue;
                concerned.addElement(fig);
                continue;
            }
            if (selectedSet.contains(fig)) continue;
            concerned.addElement(fig);
        }
        switch (this.selectMode) {
            case 2: 
            case 3: {
                view.removeFromSelectionAll(concerned);
                break;
            }
            case 0: 
            case 4: {
                view.clearSelection();
            }
            default: {
                view.addToSelectionAll(concerned);
            }
        }
        view.checkDamage();
    }
}

