/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import java.awt.Point;
import java.util.Vector;

class RamerDouglasPeucker {
    public static final double MAX_TOLERANCE = 3.0;
    private static final int TAIL_WINDOW_SIZE = 50;

    private RamerDouglasPeucker() {
    }

    public static Vector<Point> simplifyBySmoothness(Vector<Point> points, double smoothness) {
        smoothness = RamerDouglasPeucker.getValidSmoothness(smoothness);
        double tolerance = RamerDouglasPeucker.convertingSmoothnessToTolerance(smoothness);
        return RamerDouglasPeucker.simplifyByTolerance(points, tolerance);
    }

    public static Vector<Point> simplifyTailBySmoothness(Vector<Point> points, double smoothness) {
        if (points.size() <= 50) {
            return RamerDouglasPeucker.simplifyBySmoothness(points, smoothness);
        }
        int startIndex = points.size() - 50;
        Vector<Point> headPoints = new Vector<Point>(points.subList(0, startIndex));
        Vector<Point> tailPoints = new Vector<Point>(points.subList(startIndex, points.size()));
        double tolerance = RamerDouglasPeucker.convertingSmoothnessToTolerance(smoothness);
        Vector<Point> simplifiedTail = RamerDouglasPeucker.simplifyBySmoothness(tailPoints, tolerance);
        Vector<Point> simplifiedPoints = new Vector<Point>();
        simplifiedPoints.addAll(headPoints);
        simplifiedPoints.addAll(simplifiedTail);
        return simplifiedPoints;
    }

    public static Vector<Point> simplifyByTolerance(Vector<Point> points, double tolerance) {
        if (points.size() < 2) {
            return points;
        }
        Vector<Point> simplifiedPoints = new Vector<Point>();
        double maxDistance = 0.0;
        int index = 0;
        int end = points.size() - 1;
        for (int i = 1; i < end; ++i) {
            double perpendicularDistance = RamerDouglasPeucker.perpendicularDistance(points.elementAt(i), points.elementAt(0), points.elementAt(end));
            if (!(perpendicularDistance > maxDistance)) continue;
            index = i;
            maxDistance = perpendicularDistance;
        }
        if (maxDistance > tolerance) {
            Vector<Point> firstLine = new Vector<Point>(points.subList(0, index + 1));
            Vector<Point> lastLine = new Vector<Point>(points.subList(index, points.size()));
            Vector<Point> recResults1 = RamerDouglasPeucker.simplifyByTolerance(firstLine, tolerance);
            Vector<Point> recResults2 = RamerDouglasPeucker.simplifyByTolerance(lastLine, tolerance);
            simplifiedPoints.addAll(recResults1.subList(0, recResults1.size() - 1));
            simplifiedPoints.addAll(recResults2);
            if (simplifiedPoints.size() < 2) {
                return points;
            }
        } else {
            simplifiedPoints.add(points.elementAt(0));
            simplifiedPoints.add(points.elementAt(points.size() - 1));
        }
        return simplifiedPoints;
    }

    private static double perpendicularDistance(Point currentPoint, Point startPoint, Point endPoint) {
        double x = currentPoint.getX();
        double y = currentPoint.getY();
        double x1 = startPoint.getX();
        double y1 = startPoint.getY();
        double x2 = endPoint.getX();
        double y2 = endPoint.getY();
        double numerator = Math.abs((y2 - y1) * x - (x2 - x1) * y + x2 * y1 - y2 * x1);
        double denominator = Math.sqrt(Math.pow(y2 - y1, 2.0) + Math.pow(x2 - x1, 2.0));
        return numerator / denominator;
    }

    private static double convertingSmoothnessToTolerance(double smoothness) {
        smoothness = RamerDouglasPeucker.getValidSmoothness(smoothness);
        double inputStart = 0.0;
        double inputEnd = 1.0;
        double outputStart = 0.0;
        double x = (3.0 - outputStart) * (smoothness - inputStart);
        double y = inputEnd - inputStart;
        return x / y + outputStart;
    }

    private static double getValidSmoothness(double smoothness) {
        return Math.max(0.0, Math.min(1.0, smoothness));
    }
}

