/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.AttributeFigure;
import CH.ifa.draw.framework.FigureChangeEvent;
import CH.ifa.draw.framework.Handle;
import CH.ifa.draw.standard.BoxHandleKit;
import CH.ifa.draw.util.GUIProperties;
import CH.ifa.draw.util.Iconkit;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import de.renew.util.StringUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ImageObserver;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.URI;
import java.util.Vector;
import org.apache.log4j.Logger;

public class ImageFigure
extends AttributeFigure
implements ImageObserver {
    public static Logger logger = Logger.getLogger(ImageFigure.class);
    private static final long serialVersionUID = 148012030121282439L;
    private String fFileName;
    private transient Image fImage;
    private Rectangle fDisplayBox;
    private int imageFigureSerializedDataVersion = 1;

    public ImageFigure() {
        this.fFileName = null;
        this.fImage = null;
        this.fDisplayBox = null;
    }

    public ImageFigure(Image image, String fileName, Point origin) {
        if (fileName != null) {
            try {
                this.fFileName = new File(fileName).getCanonicalPath();
            }
            catch (IOException e) {
                logger.error((Object)("Could not find file " + fileName + ": " + String.valueOf(e)));
            }
        } else {
            this.fFileName = null;
        }
        this.fImage = image;
        this.fDisplayBox = new Rectangle(origin.x, origin.y, 0, 0);
        this.fDisplayBox.width = this.fImage.getWidth(this);
        this.fDisplayBox.height = this.fImage.getHeight(this);
    }

    @Override
    public void basicDisplayBox(Point origin, Point corner) {
        this.fDisplayBox = new Rectangle(origin);
        this.fDisplayBox.add(corner);
    }

    @Override
    public Vector<Handle> handles() {
        Vector<Handle> handles = new Vector<Handle>();
        BoxHandleKit.addHandles(this, handles);
        return handles;
    }

    @Override
    public Rectangle displayBox() {
        return new Rectangle(this.fDisplayBox.x, this.fDisplayBox.y, this.fDisplayBox.width, this.fDisplayBox.height);
    }

    @Override
    protected void basicMoveBy(int x, int y) {
        this.fDisplayBox.translate(x, y);
    }

    @Override
    public void internalDraw(Graphics g) {
        if (this.fImage == null && this.fFileName != null) {
            this.fImage = Iconkit.instance().getImage(this.fFileName);
        }
        if (this.fImage != null && new File(this.fFileName).exists()) {
            g.drawImage(this.fImage, this.fDisplayBox.x, this.fDisplayBox.y, this.fDisplayBox.width, this.fDisplayBox.height, this);
        } else {
            this.drawGhost(g);
        }
    }

    private void drawGhost(Graphics g) {
        g.setColor(Color.gray);
        g.fillRect(this.fDisplayBox.x, this.fDisplayBox.y, this.fDisplayBox.width, this.fDisplayBox.height);
    }

    @Override
    public boolean imageUpdate(Image img, int flags, int x, int y, int w, int h) {
        if ((flags & 0x30) != 0) {
            this.invalidate();
            if (this.listener() != null) {
                this.listener().figureRequestUpdate(new FigureChangeEvent(this));
            }
        }
        return (flags & 0xA0) == 0;
    }

    @Override
    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeInt(this.fDisplayBox.x);
        dw.writeInt(this.fDisplayBox.y);
        dw.writeInt(this.fDisplayBox.width);
        dw.writeInt(this.fDisplayBox.height);
        URI imageURI = new File(this.fFileName).toURI();
        imageURI = StringUtil.makeRelative((URI)dw.getURI(), (URI)imageURI);
        String relativePath = imageURI.getPath();
        dw.writeString(relativePath);
        logger.debug((Object)relativePath);
    }

    @Override
    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.fDisplayBox = new Rectangle(dr.readInt(), dr.readInt(), dr.readInt(), dr.readInt());
        this.fFileName = dr.readString();
        URI uri = null;
        try {
            uri = dr.getURI().resolve(this.fFileName);
            this.fFileName = new File(uri).getCanonicalPath();
            logger.debug((Object)("Including image from location: " + this.fFileName));
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)("Problem while resolving image location: " + String.valueOf(e)));
        }
        catch (IOException e) {
            logger.error((Object)("Problem while resolving image location: " + String.valueOf(e)));
            this.fFileName = uri != null ? uri.getPath() : null;
        }
        catch (NullPointerException e) {
            logger.debug((Object)"StorableInput has no URI!");
        }
        if (!GUIProperties.noGraphics()) {
            Iconkit.instance().registerImage(this.fFileName);
        }
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        Iconkit.instance().registerImage(this.fFileName);
        this.fImage = null;
    }
}

