/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.util.Storable;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.awt.Color;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.log4j.Logger;

public class FigureAttributes
implements Cloneable,
Serializable {
    private static Logger logger = Logger.getLogger(FigureAttributes.class);
    private static final long serialVersionUID = -6886355144423666716L;
    private Hashtable<String, Object> fMap = new Hashtable();
    private int figureAttributesSerializedDataVersion = 1;

    public Object get(String name) {
        return this.fMap.get(name);
    }

    public void set(String name, Object value) {
        if (value == null) {
            this.fMap.remove(name);
        } else {
            this.fMap.put(name, value);
        }
    }

    public boolean hasDefined(String name) {
        return this.fMap.containsKey(name);
    }

    public Enumeration<String> definedAttributes() {
        return this.fMap.keys();
    }

    public Object clone() {
        try {
            FigureAttributes a = (FigureAttributes)super.clone();
            a.fMap = new Hashtable<String, Object>(this.fMap);
            return a;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public void read(StorableInput dr) throws IOException {
        String s = dr.readString();
        if (!s.toLowerCase().equals("attributes")) {
            throw new IOException("Attributes expected");
        }
        int version = dr.getVersion();
        int size = dr.readInt();
        for (int i = 0; i < size; ++i) {
            String key = dr.readString();
            String valtype = dr.readString();
            Object val = null;
            if (valtype.equals("Color")) {
                val = version < 11 ? new Color(dr.readInt(), dr.readInt(), dr.readInt()) : new Color(dr.readInt(), dr.readInt(), dr.readInt(), dr.readInt());
            } else if (valtype.equals("Boolean")) {
                val = Boolean.valueOf(dr.readString());
            } else if (valtype.equals("String")) {
                val = dr.readString();
            } else if (valtype.equals("Int")) {
                val = dr.readInt();
            } else if (valtype.equals("Storable")) {
                val = dr.readStorable();
            } else if (valtype.equals("UNKNOWN")) continue;
            this.fMap.put(key, val);
        }
    }

    public void write(StorableOutput dw) {
        dw.writeString("attributes");
        dw.writeInt(this.fMap.size());
        Enumeration<String> k = this.fMap.keys();
        while (k.hasMoreElements()) {
            String s = k.nextElement();
            dw.writeString(s);
            Object v = this.fMap.get(s);
            if (v instanceof String) {
                dw.writeString("String");
                dw.writeString((String)v);
                continue;
            }
            if (v instanceof Color) {
                dw.writeString("Color");
                dw.writeInt(((Color)v).getRed());
                dw.writeInt(((Color)v).getGreen());
                dw.writeInt(((Color)v).getBlue());
                dw.writeInt(((Color)v).getAlpha());
                continue;
            }
            if (v instanceof Boolean) {
                dw.writeString("Boolean");
                if (((Boolean)v).booleanValue()) {
                    dw.writeString("TRUE");
                    continue;
                }
                dw.writeString("FALSE");
                continue;
            }
            if (v instanceof Integer) {
                dw.writeString("Int");
                dw.writeInt((Integer)v);
                continue;
            }
            if (v instanceof Storable) {
                dw.writeString("Storable");
                dw.writeStorable((Storable)v);
                continue;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(FigureAttributes.class.getSimpleName() + ": Unknown attribute type: " + String.valueOf(v)));
            }
            dw.writeString("UNKNOWN");
        }
    }
}

