/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.AttributeFigure;
import CH.ifa.draw.figures.ChopEllipseConnector;
import CH.ifa.draw.framework.Connector;
import CH.ifa.draw.framework.Handle;
import CH.ifa.draw.standard.BoxHandleKit;
import CH.ifa.draw.util.Geom;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Ellipse2D;
import java.io.IOException;
import java.util.Vector;

public class EllipseFigure
extends AttributeFigure {
    private static final long serialVersionUID = -6856203289355118951L;
    private Rectangle fDisplayBox;
    private int ellipseFigureSerializedDataVersion = 1;

    public EllipseFigure() {
        this(new Point(0, 0), new Point(0, 0));
    }

    public EllipseFigure(Point origin, Point corner) {
        this.basicDisplayBox(origin, corner);
    }

    @Override
    public Vector<Handle> handles() {
        Vector<Handle> handles = new Vector<Handle>();
        BoxHandleKit.addHandles(this, handles);
        return handles;
    }

    @Override
    public void basicDisplayBox(Point origin, Point corner) {
        this.fDisplayBox = new Rectangle(origin);
        this.fDisplayBox.add(corner);
    }

    @Override
    public Rectangle displayBox() {
        return new Rectangle(this.fDisplayBox.x, this.fDisplayBox.y, this.fDisplayBox.width, this.fDisplayBox.height);
    }

    @Override
    public boolean containsPoint(int x, int y) {
        if (super.containsPoint(x, y)) {
            return Geom.ellipseContainsPoint(this.displayBox(), x, y);
        }
        return false;
    }

    @Override
    protected void basicMoveBy(int x, int y) {
        this.fDisplayBox.translate(x, y);
    }

    @Override
    public void drawBackground(Graphics g) {
        Rectangle r = this.displayBox();
        Graphics2D g2 = (Graphics2D)g;
        Ellipse2D.Double s = new Ellipse2D.Double(r.x, r.y, r.width, r.height);
        g2.fill(s);
    }

    @Override
    public void drawFrame(Graphics g) {
        Rectangle r = this.displayBox();
        Graphics2D g2 = (Graphics2D)g;
        Ellipse2D.Double s = new Ellipse2D.Double(r.x, r.y, r.width, r.height);
        g2.draw(s);
    }

    @Override
    public Insets connectionInsets() {
        Rectangle r = this.fDisplayBox;
        int cx = r.width / 2;
        int cy = r.height / 2;
        return new Insets(cy, cx, cy, cx);
    }

    @Override
    public Connector connectorAt(int x, int y) {
        return new ChopEllipseConnector(this);
    }

    @Override
    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeInt(this.fDisplayBox.x);
        dw.writeInt(this.fDisplayBox.y);
        dw.writeInt(this.fDisplayBox.width);
        dw.writeInt(this.fDisplayBox.height);
    }

    @Override
    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.fDisplayBox = new Rectangle(dr.readInt(), dr.readInt(), dr.readInt(), dr.readInt());
    }
}

