/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.FigureAttributes;
import CH.ifa.draw.figures.PolyLineFigure;
import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.DrawingContext;
import CH.ifa.draw.framework.FigureWithID;
import CH.ifa.draw.standard.AbstractFigure;
import CH.ifa.draw.util.ColorMap;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.io.IOException;
import java.util.Enumeration;
import org.freehep.graphicsio.HyperrefGraphics;

public abstract class AttributeFigure
extends AbstractFigure
implements FigureWithID {
    private static final String _idAttr = "FigureWithID";
    private static final long serialVersionUID = -10857585979273442L;
    private static FigureAttributes fgDefaultAttributes = null;
    public static final String LINE_STYLE_NORMAL = "";
    public static final String LINE_STYLE_DOTTED = "1 2";
    public static final String LINE_STYLE_DASHED = "10";
    public static final String LINE_STYLE_MEDIUM_DASHED = "15 10";
    public static final String LINE_STYLE_LONG_DASHED = "20";
    public static final String LINE_STYLE_DASH_DOTTED = "7 3 1 3";
    public static final String LINE_WIDTH_KEY = "LineWidth";
    public static final Integer LINE_WIDTH_DEFAULT = 1;
    private FigureAttributes fAttributes;
    private int attributeFigureSerializedDataVersion = 1;

    protected AttributeFigure() {
    }

    public static Object getDefaultAttribute(String name) {
        if (fgDefaultAttributes == null) {
            AttributeFigure.initializeAttributes();
        }
        return fgDefaultAttributes.get(name);
    }

    public void internalDraw(Graphics g) {
        Color frame;
        Color fill = this.getFillColor();
        if (!ColorMap.isTransparent(fill)) {
            g.setColor(fill);
            this.drawBackground(g);
        }
        if (!ColorMap.isTransparent(frame = this.getFrameColor())) {
            g.setColor(frame);
            Graphics2D g2 = (Graphics2D)g;
            String lineStyle = this.getLineStyle();
            BasicStroke stroke = (BasicStroke)g2.getStroke();
            BasicStroke bs = new BasicStroke(this.getLineWidth().intValue(), stroke.getEndCap(), stroke.getLineJoin(), stroke.getMiterLimit(), this.lineStyle2ArrayOfFloat(lineStyle), stroke.getDashPhase());
            g2.setStroke(bs);
            this.drawFrame(g2);
            g2.setStroke(stroke);
        }
    }

    @Override
    public void draw(Graphics g) {
        if (this.isVisible()) {
            if (g instanceof HyperrefGraphics && this.hasAttribute("targetLocation").booleanValue()) {
                ((HyperrefGraphics)g).drawLink((Shape)this.displayBox(), (String)this.getAttribute("targetLocation"));
            }
            this.internalDraw(g);
            if (g instanceof HyperrefGraphics && this.hasAttribute("targetLocation").booleanValue()) {
                ((HyperrefGraphics)g).drawLinkEnd();
            }
        }
    }

    @Override
    public void draw(Graphics g, DrawingContext dc) {
        if (!dc.isVisible(this)) {
            return;
        }
        if (dc.isHighlighted(this)) {
            Color fill = this.getFillColor();
            Color frame = this.getFrameColor();
            Color text = null;
            if (ColorMap.isTransparent(fill) || ColorMap.isBackground(fill) || this instanceof PolyLineFigure) {
                if (this instanceof TextFigure) {
                    text = (Color)this.getAttribute("TextColor");
                    this.setTextColor(ColorMap.hilight(text));
                } else if (!ColorMap.isTransparent(frame) && !ColorMap.isBackground(fill)) {
                    this.setFrameColor(ColorMap.hilight(frame));
                }
            } else {
                this.setFillColor(ColorMap.hilight(fill));
            }
            this.internalDraw(g);
            this.setFillColor(fill);
            this.setFrameColor(frame);
            if (text != null) {
                this.setTextColor(text);
            }
        } else {
            this.internalDraw(g);
        }
    }

    protected void drawBackground(Graphics g) {
    }

    protected void drawFrame(Graphics g) {
    }

    public Color getFillColor() {
        return (Color)this.getAttribute("FillColor");
    }

    public void setFillColor(Color color) {
        if (this.fAttributes == null) {
            this.fAttributes = new FigureAttributes();
        }
        this.fAttributes.set("FillColor", color);
    }

    public void setFrameColor(Color color) {
        if (this.fAttributes == null) {
            this.fAttributes = new FigureAttributes();
        }
        this.fAttributes.set("FrameColor", color);
    }

    public void setTextColor(Color color) {
        if (this.fAttributes == null) {
            this.fAttributes = new FigureAttributes();
        }
        this.fAttributes.set("TextColor", color);
    }

    private static void initializeAttributes() {
        fgDefaultAttributes = new FigureAttributes();
        fgDefaultAttributes.set("FrameColor", Color.black);
        fgDefaultAttributes.set("FillColor", new Color(7396243));
        fgDefaultAttributes.set("TextColor", Color.black);
        fgDefaultAttributes.set("TextAlignment", 0);
        fgDefaultAttributes.set("ArrowMode", 0);
        fgDefaultAttributes.set("FontName", "Helvetica");
        fgDefaultAttributes.set("FontSize", 12);
        fgDefaultAttributes.set("FontStyle", 0);
        fgDefaultAttributes.set("LineShape", 0);
        fgDefaultAttributes.set("BSplineSegments", 15);
        fgDefaultAttributes.set("BSplineDegree", 2);
        fgDefaultAttributes.set(_idAttr, 0);
    }

    public Color getFrameColor() {
        return (Color)this.getAttribute("FrameColor");
    }

    @Override
    public Object getAttribute(String name) {
        if (this.fAttributes != null && this.fAttributes.hasDefined(name)) {
            return this.fAttributes.get(name);
        }
        Object supAttr = super.getAttribute(name);
        if (supAttr == null) {
            return AttributeFigure.getDefaultAttribute(name);
        }
        return supAttr;
    }

    public Boolean hasAttribute(String name) {
        if (this.fAttributes != null && this.fAttributes.hasDefined(name)) {
            return true;
        }
        if (super.getAttribute(name) != null) {
            return true;
        }
        return false;
    }

    public Enumeration<String> getAttributeKeys() {
        Enumeration<String> attr = new Enumeration<String>(){

            @Override
            public boolean hasMoreElements() {
                return false;
            }

            @Override
            public String nextElement() {
                return null;
            }
        };
        if (this.fAttributes != null) {
            attr = this.fAttributes.definedAttributes();
        }
        return attr;
    }

    @Override
    public void setAttribute(String name, Object value) {
        super.setAttribute(name, value);
        if (this.fAttributes == null) {
            this.fAttributes = new FigureAttributes();
        }
        this.fAttributes.set(name, value);
        this.changed();
    }

    @Override
    public void write(StorableOutput dw) {
        super.write(dw);
        if (this.fAttributes == null) {
            dw.writeString("no_attributes");
        } else {
            dw.writeString("attributes");
            this.fAttributes.write(dw);
        }
    }

    @Override
    public void read(StorableInput dr) throws IOException {
        Object lineStyle;
        super.read(dr);
        String s = dr.readString();
        if (s.toLowerCase().equals("attributes")) {
            if (this.fAttributes == null) {
                this.fAttributes = new FigureAttributes();
            }
            this.fAttributes.read(dr);
            Enumeration<String> attrenumeration = this.fAttributes.definedAttributes();
            while (attrenumeration.hasMoreElements()) {
                String attr = attrenumeration.nextElement();
                Object val = this.fAttributes.get(attr);
                super.setAttribute(attr, val);
            }
        }
        if ((lineStyle = this.getAttribute("LineStyle")) instanceof Integer) {
            int value = (Integer)lineStyle;
            if (value <= 0) {
                this.setAttribute("LineStyle", null);
            } else {
                this.setAttribute("LineStyle", lineStyle.toString());
            }
        }
    }

    @Override
    public int getID() {
        return (Integer)this.getAttribute(_idAttr);
    }

    @Override
    public void setID(int id) {
        this.setAttribute(_idAttr, id);
    }

    protected String getLineStyle() {
        String lineStyle = (String)this.getAttribute("LineStyle");
        if (lineStyle == null) {
            return LINE_STYLE_NORMAL;
        }
        return lineStyle;
    }

    protected Integer getLineWidth() {
        Integer lineWidth = (Integer)this.getAttribute(LINE_WIDTH_KEY);
        if (lineWidth == null) {
            return LINE_WIDTH_DEFAULT;
        }
        return lineWidth;
    }

    protected void setLineWidth(Integer width) {
        this.setAttribute(LINE_WIDTH_KEY, width);
    }

    protected void setLineStyle(String lineStyle) {
        this.setAttribute("LineStyle", lineStyle);
    }

    protected BasicStroke getBasicStroke(String lineStyle) {
        float[] f = this.lineStyle2ArrayOfFloat(lineStyle);
        return new BasicStroke(1.0f, 0, 2, 0.0f, f, 0.0f);
    }

    private float[] lineStyle2ArrayOfFloat(String lineStyle) {
        float[] f;
        if (lineStyle != LINE_STYLE_NORMAL && lineStyle.length() != 0) {
            String[] split = lineStyle.split(" ");
            f = new float[split.length];
            for (int i = 0; i < split.length; ++i) {
                f[i] = Float.parseFloat(split[i]);
            }
        } else {
            f = null;
        }
        return f;
    }
}

