/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.contrib;

import CH.ifa.draw.contrib.PolygonFigure;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Locator;
import CH.ifa.draw.standard.AbstractHandle;
import CH.ifa.draw.util.Geom;
import java.awt.Point;
import java.awt.event.MouseEvent;

public class PolygonHandle
extends AbstractHandle {
    private int fIndex;
    private Locator fLocator;

    public PolygonHandle(PolygonFigure owner, Locator l, int index) {
        super(owner);
        this.fLocator = l;
        this.fIndex = index;
    }

    @Override
    public void invokeStart(MouseEvent e, int x, int y, DrawingView view) {
        super.invokeStart(e, x, y, view);
        if (e.getClickCount() > 1) {
            this.myOwner().removePointAt(this.fIndex);
            view.selectionInvalidateHandles();
        }
    }

    @Override
    public void invokeStep(MouseEvent e, int x, int y, int anchorX, int anchorY, DrawingView view) {
        Point p;
        PolygonFigure plf = this.myOwner();
        if (e.isControlDown() && this.fIndex >= 0 && this.fIndex < plf.pointCount()) {
            int prevCount = this.fIndex - 1;
            int nextCount = this.fIndex + 1;
            if (this.fIndex == 0) {
                prevCount = plf.pointCount() - 1;
            } else if (this.fIndex == plf.pointCount() - 1) {
                nextCount = 0;
            }
            Point prev = plf.pointAt(prevCount);
            Point next = plf.pointAt(nextCount);
            Point corner1 = new Point(prev.x, next.y);
            Point corner2 = new Point(next.x, prev.y);
            p = Geom.length(x, y, corner1.x, corner1.y) < Geom.length(x, y, corner2.x, corner2.y) ? corner1 : corner2;
        } else {
            p = new Point(x, y);
        }
        this.myOwner().setPointAt(p, this.fIndex);
    }

    @Override
    public void invokeEnd(int x, int y, int anchorX, int anchorY, DrawingView view) {
        this.myOwner().smoothPoints();
        super.invokeEnd(x, y, anchorX, anchorY, view);
    }

    @Override
    public Point locate() {
        return this.fLocator.locate(this.owner());
    }

    private PolygonFigure myOwner() {
        return (PolygonFigure)this.owner();
    }
}

