/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.contrib;

import CH.ifa.draw.contrib.ChopPolygonConnector;
import CH.ifa.draw.contrib.OutlineFigure;
import CH.ifa.draw.figures.RectangleFigure;
import CH.ifa.draw.framework.Connector;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;

public class DiamondFigure
extends RectangleFigure
implements OutlineFigure {
    public DiamondFigure() {
        super(new Point(0, 0), new Point(0, 0));
    }

    public DiamondFigure(Point origin, Point corner) {
        super(origin, corner);
    }

    public Shape polygon() {
        return this.polygon(0);
    }

    public Shape polygon(int offset) {
        Rectangle r = this.displayBox();
        GeneralPath thePath = new GeneralPath();
        thePath.moveTo(r.x + r.width / 2, r.y + r.height);
        thePath.lineTo(r.x + r.width, r.y + r.height / 2);
        thePath.lineTo(r.x + r.width / 2, r.y);
        thePath.lineTo(r.x, r.y + r.height / 2);
        thePath.closePath();
        return thePath;
    }

    @Override
    public Polygon outline() {
        Rectangle r = this.displayBox();
        r.setRect(r.x, r.y, r.width, r.height);
        Polygon p = new Polygon();
        p.addPoint(r.x, r.y + r.height / 2);
        p.addPoint(r.x + r.width / 2, r.y);
        p.addPoint(r.x + r.width, r.y + r.height / 2);
        p.addPoint(r.x + r.width / 2, r.y + r.height);
        return p;
    }

    @Override
    public Connector connectorAt(int x, int y) {
        return new ChopPolygonConnector(this);
    }

    @Override
    public void drawBackground(Graphics g) {
        g.setColor(this.getFillColor());
        ((Graphics2D)g).fill(this.polygon());
    }

    @Override
    public void drawFrame(Graphics g) {
        g.setColor(this.getFrameColor());
        ((Graphics2D)g).draw(this.polygon());
    }

    @Override
    public Insets connectionInsets() {
        Rectangle r = this.displayBox();
        return new Insets(r.height / 2, r.width / 2, r.height / 2, r.width / 2);
    }

    @Override
    public boolean containsPoint(int x, int y) {
        return this.polygon().contains(x, y);
    }
}

